/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.framework.JavaeeFrameworkDetector;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WebFrameworkDetector
extends JavaeeFrameworkDetector<WebFacet, WebFacetConfiguration> {
    public WebFrameworkDetector() {
        super("web");
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName(DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName()).andOr(new ElementPattern[]{FileContentPattern.fileContent().xmlWithRootTag("web-app"), FileContentPattern.fileContent().inDirectory("WEB-INF")});
        if (objectPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkDetector", "createSuitableFilePattern"));
        }
        return objectPattern;
    }

    @Override
    @NotNull
    public WebFacetType getFacetType() {
        WebFacetType webFacetType = WebFacetType.getInstance();
        if (webFacetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkDetector", "getFacetType"));
        }
        return webFacetType;
    }

    public FrameworkType getFrameworkType() {
        return WebFrameworkType.getInstance();
    }

    public void setupFacet(@NotNull WebFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/web/framework/WebFrameworkDetector", "setupFacet"));
        }
        String[] sourceRootUrls = model.getSourceRootUrls(false);
        ((WebFacetConfigurationImpl)facet.getConfiguration()).setSourceRoots(Arrays.asList(sourceRootUrls));
    }

    @Override
    protected void setupConfiguration(WebFacetConfiguration configuration, VirtualFile file) {
        WebFacetConfigurationImpl configurationImpl = (WebFacetConfigurationImpl)configuration;
        VirtualFile parent = file.getParent();
        if (parent != null) {
            VirtualFile grandParent = parent.getParent();
            String webInf = DeploymentDescriptorsConstants.WEB_XML_META_DATA.getDirectoryPath();
            WebRootData webRoot = grandParent != null && webInf.equals(parent.getName()) ? new WebRootData(grandParent.getUrl(), "/") : new WebRootData(parent.getUrl(), "/" + webInf);
            configurationImpl.addWebRoot(webRoot);
        }
    }
}

