/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.framework.JavaeeFrameworkSupportProviderBase;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.javaee.web.framework.WebFrameworkVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFrameworkSupportProvider
extends JavaeeFrameworkSupportProviderBase<WebFacet> {
    private static final Logger LOG = Logger.getInstance(WebFrameworkSupportProvider.class);

    public WebFrameworkSupportProvider() {
        super(WebFacetType.getInstance(), DeploymentDescriptorsConstants.WEB_XML_META_DATA, "/web");
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        WebFrameworkType webFrameworkType = WebFrameworkType.getInstance();
        if (webFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkSupportProvider", "getFrameworkType"));
        }
        return webFrameworkType;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/web/framework/WebFrameworkSupportProvider", "createConfigurable"));
        }
        WebFrameworkSupportConfigurable webFrameworkSupportConfigurable = new WebFrameworkSupportConfigurable(model);
        if (webFrameworkSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkSupportProvider", "createConfigurable"));
        }
        return webFrameworkSupportConfigurable;
    }

    public String getPresentableName() {
        return "Web Application";
    }

    public String getVersionLabel() {
        return "Specification version:";
    }

    @Override
    protected void setupConfiguration(WebFacet facet, ModifiableRootModel rootModel, ConfigFileVersion configFileVersion) {
        super.setupConfiguration(facet, rootModel, configFileVersion);
        String webDirUrl = rootModel.getContentRootUrls()[0] + "/web";
        facet.addWebRoot(webDirUrl, "/");
        WebFacetImpl webFacet = (WebFacetImpl)facet;
        webFacet.getWebConfiguration().setSourceRoots(Arrays.asList(rootModel.getSourceRootUrls(false)));
    }

    @Override
    protected void createFiles(WebFacet facet, JavaeeFrameworkSupportInfoCollector collector) {
        List webRoots = facet.getWebRoots();
        if (webRoots.isEmpty()) {
            return;
        }
        String webRootUrl = ((WebRoot)webRoots.get(0)).getDirectoryUrl();
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)webRootUrl)), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = facet.getModule().getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
            collector.setIndexJsp(indexFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public void processAddedLibraries(Module module, List<Library> addedLibraries) {
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module), null);
        if (webFacet != null) {
            Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
            for (Artifact artifact : artifacts) {
                for (Library library : addedLibraries) {
                    if (JavaeeArtifactTypeBase.isStandardJavaeeLibary(library)) continue;
                    WebArtifactUtil.getInstance().addLibrary(library, artifact, module.getProject());
                }
            }
        }
    }

    public class WebFrameworkSupportConfigurable
    extends JavaeeFrameworkSupportProviderBase.JavaeeFrameworkSupportConfigurable {
        private JPanel myPanel;
        private JCheckBox myCreateWebXmlBox;
        private boolean myCreateWebXml;

        public WebFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super(WebFrameworkSupportProvider.this, model);
            this.myPanel = new JPanel(new BorderLayout());
            this.myCreateWebXmlBox = new JCheckBox("Create web.xml");
            this.myCreateWebXml = true;
            this.myPanel.add((Component)this.myCreateWebXmlBox, "Center");
            this.myCreateWebXmlBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFrameworkSupportConfigurable.this.myCreateWebXml = WebFrameworkSupportConfigurable.this.myCreateWebXmlBox.isSelected();
                }
            });
            ((FrameworkSupportModelBase)model).addFrameworkVersionListener(new FrameworkVersionListener(){

                public void versionChanged(FrameworkVersion version) {
                    if (version instanceof WebFrameworkVersion) {
                        WebFrameworkSupportConfigurable.this.updateCheckBox();
                    }
                }
            }, (Disposable)this);
        }

        @Override
        @Nullable
        protected ConfigFileVersion getVersionToCreate(JavaeeFrameworkVersionBase frameworkVersion) {
            if (!this.myCreateWebXmlBox.isSelected()) {
                return null;
            }
            return super.getVersionToCreate(frameworkVersion);
        }

        private void updateCheckBox() {
            FrameworkVersion version = ((FrameworkSupportModelBase)this.myModel).getSelectedVersion(WebFrameworkType.getInstance().getId());
            boolean isWebXmlOptional = version instanceof WebFrameworkVersion && ((WebFrameworkVersion)version).isWebXmlOptional();
            this.myCreateWebXmlBox.setSelected(!isWebXmlOptional || this.myCreateWebXml);
            this.myCreateWebXmlBox.setVisible(isWebXmlOptional);
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            this.updateCheckBox();
            return this.myPanel;
        }

        public JCheckBox getCheckBox() {
            return this.myCreateWebXmlBox;
        }
    }
}

