/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Collection;
import java.util.function.Predicate;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;

class PackageNameSelectorResolver
implements DiscoverySelectorResolver {
    private final Predicate<String> classNamePredicate;

    PackageNameSelectorResolver(Predicate<String> classNamePredicate) {
        this.classNamePredicate = classNamePredicate;
    }

    @Override
    public void resolve(EngineDiscoveryRequest request, TestClassCollector collector) {
        request.getSelectorsByType(PackageSelector.class).stream().map(PackageSelector::getPackageName).map(packageName -> ReflectionUtils.findAllClassesInPackage((String)packageName, (Predicate)classTester, this.classNamePredicate)).flatMap(Collection::stream).forEach(collector::addCompletely);
    }
}

