/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.spring.model.converters.PackageListConverter;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.converters.resources.ResourceValueConverter;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringPersistenceConverters {
    private static Condition<Pair<PsiType, GenericDomValue>> createBeanPropertyCondition(String propertyName, boolean annotationsOnly) {
        return pair -> {
            GenericDomValue domValue = (GenericDomValue)pair.getSecond();
            SpringProperty property = (SpringProperty)domValue.getParentOfType(SpringProperty.class, true);
            return property != null && propertyName.equals(property.getName().getStringValue());
        };
    }

    public static class AnnotatedPackagesConverter
    extends ResourceValueConverter
    implements GenericDomValueConvertersRegistry.Provider {
        @NotNull
        public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
            SmartList result = new SmartList();
            int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
            SpringReferenceUtils.processSeparatedString((String)genericDomValue.getStringValue(), (String)",", (arg_0, arg_1) -> AnnotatedPackagesConverter.lambda$createReferences$0((List)result, element, startInElement, arg_0, arg_1));
            PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
            if (psiReferenceArray == null) {
                AnnotatedPackagesConverter.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }

        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("annotatedPackages", true);
        }

        private static /* synthetic */ boolean lambda$createReferences$0(List result, PsiElement element, int startInElement, String s, Integer offset) {
            result.addAll(new PackageReferenceSet(s, element, offset + startInElement).getReferences());
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/converters/SpringPersistenceConverters$AnnotatedPackagesConverter", "createReferences"));
        }
    }

    public static class MappingResourcesConverter
    extends ResourceValueConverter
    implements GenericDomValueConvertersRegistry.Provider {
        @NotNull
        public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
            SmartList result = new SmartList();
            int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
            SpringReferenceUtils.processSeparatedString((String)genericDomValue.getStringValue(), (String)",", (arg_0, arg_1) -> MappingResourcesConverter.lambda$createReferences$0(element, startInElement, (List)result, arg_0, arg_1));
            PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
            if (psiReferenceArray == null) {
                MappingResourcesConverter.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }

        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("mappingResources", false);
        }

        private static /* synthetic */ boolean lambda$createReferences$0(PsiElement element, int startInElement, List result, String s, Integer offset) {
            Object[] references = SpringResourcesUtil.getInstance().getClassPathReferences(SpringResourcesBuilder.create((PsiElement)element, (String)s).offset(offset + startInElement));
            ContainerUtil.addAll((Collection)result, (Object[])references);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/converters/SpringPersistenceConverters$MappingResourcesConverter", "createReferences"));
        }
    }

    public static class MyPackageConverter
    extends PackageListConverter
    implements GenericDomValueConvertersRegistry.Provider {
        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return SpringPersistenceConverters.createBeanPropertyCondition("packagesToScan", true);
        }

        protected String getDelimiters() {
            return ",";
        }
    }
}

