/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DelegatingCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer myDelegate;

    public DelegatingCellRenderer(TableCellRenderer delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditedStyleItem item = value instanceof EditedStyleItem ? (EditedStyleItem)value : null;
        Component returnedComponent = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ConfiguredThemeEditorStyle selectedStyle = ((AttributesTableModel)table.getModel()).getSelectedStyle();
        returnedComponent.setFont(selectedStyle.hasItem(item) ? returnedComponent.getFont().deriveFont(1) : returnedComponent.getFont().deriveFont(0));
        returnedComponent.setForeground((Color)(item != null && !item.isPublicAttribute() ? JBColor.LIGHT_GRAY : table.getForeground()));
        return returnedComponent;
    }
}

