/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(0);
        }
        if (to == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(2);
        }
        final Project project = from.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        String gradlePath = GradleUtil.getGradlePath(to);
        final GradleBuildModel buildModel = GradleBuildModel.get(from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope, openedFile);
            dependencies.addModule(configurationName, gradlePath, null);
            new WriteCommandAction(project, "Add Gradle Module Dependency", new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    buildModel.applyChanges();
                    AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$1", "run"));
                }
            }.execute();
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (modules == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(5);
        }
        ArtifactDependencySpec dependencySpec = new ArtifactDependencySpec(descriptor.getLibraryArtifactId(), descriptor.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules, dependencySpec, scope);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(6);
        }
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(8);
        }
        if (!Projects.isBuildWithGradle(from)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<Module>)ImmutableList.of((Object)from), dependencySpec, scope);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope) {
        Module firstModule;
        if (modules == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(9);
        }
        if (dependencySpec == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(11);
        }
        if ((firstModule = (Module)Iterables.getFirst(modules, null)) == null) {
            return null;
        }
        final Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        final ArrayList buildModelsToUpdate = Lists.newArrayList();
        for (Module module : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module, scope, openedFile);
            DependenciesModel dependencies = buildModel.dependencies();
            dependencies.addArtifact(configurationName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        new WriteCommandAction(project, "Add Gradle Library Dependency", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (GradleBuildModel buildModel : buildModelsToUpdate) {
                    buildModel.applyChanges();
                }
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$2", "run"));
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        if (module == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(12);
        }
        if (level == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(13);
        }
        final Project project = module.getProject();
        if (!Projects.isBuildWithGradle(module)) {
            return null;
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return null;
        }
        if (Projects.getAndroidModel(module) != null) {
            AndroidModel android = buildModel.android();
            if (android == null) {
                return null;
            }
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.setSourceCompatibility(level);
            compileOptions.setTargetCompatibility(level);
        } else {
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet == null || javaFacet.getJavaModuleModel() == null) {
                return null;
            }
            JavaModel javaModel = buildModel.java();
            javaModel.setSourceCompatibility(level);
            javaModel.setTargetCompatibility(level);
        }
        new WriteCommandAction(project, "Change Gradle Language Level", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$3", "run"));
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module, @NotNull DependencyScope scope, @Nullable VirtualFile openedFile) {
        TestArtifactSearchScopes testScopes;
        if (module == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(15);
        }
        if (!scope.isForProductionCompile() && (testScopes = TestArtifactSearchScopes.get(module)) != null && openedFile != null) {
            String string = testScopes.isAndroidTestSource(openedFile) ? "androidTestCompile" : "testCompile";
            if (string == null) {
                AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(16);
            }
            return string;
        }
        if ("compile" == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(17);
        }
        return "compile";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor) {
        if (descriptor == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(18);
        }
        String groupAndId = descriptor.getLibraryGroupId() + ":" + descriptor.getLibraryArtifactId();
        return EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(19);
        }
        final AsyncPromise promise = new AsyncPromise();
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(2);
                }
                promise.setError(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(20);
        }
        return asyncPromise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(21);
        }
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(22);
        }
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(23);
        }
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || LibraryUtil.findLibrary((Module)module, (String)library.getName()) == null) continue;
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModuleModel);
            break;
        }
        if (result == null) {
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull AndroidModuleModel androidModel) {
        BaseArtifact testArtifact;
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(24);
        }
        if (androidModel == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(25);
        }
        GradleVersion modelVersion = androidModel.getModelVersion();
        JavaLibrary matchedLibrary = null;
        Iterator<BaseArtifact> iterator = androidModel.getTestArtifactsInSelectedVariant().iterator();
        while (iterator.hasNext() && (matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, testArtifact = iterator.next(), modelVersion)) == null) {
        }
        if (matchedLibrary == null) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (BaseArtifact)selectedVariant.getMainArtifact(), modelVersion);
        }
        if (matchedLibrary == null) {
            return null;
        }
        MavenCoordinates coordinates = matchedLibrary.getResolvedCoordinates();
        if (coordinates == null) {
            return null;
        }
        return new ArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
    }

    @Nullable
    private static JavaLibrary findMatchedLibrary(@NotNull Library library, @NotNull BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(26);
        }
        if (artifact == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(27);
        }
        Dependencies dependencies = GradleUtil.getDependencies(artifact, modelVersion);
        for (JavaLibrary gradleLibrary : dependencies.getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)gradleLibrary.getJarFile());
            if (!libraryName.equals(library.getName())) continue;
            return gradleLibrary;
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files;
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(28);
        }
        if ((files = library.getFiles(OrderRootType.CLASSES)).length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version)) continue;
            return new ArtifactDependencySpec(artifactId, groupId, version);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySpec";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "requestProjectSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addExternalLibraryDependency";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageLevel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationName";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectVersion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerUndoAction";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNewExternalDependency";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedLibrary";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findNewExternalDependencyByExaminingPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

