/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(0);
        }
        GradleDependencyManager gradleDependencyManager = (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
        if (gradleDependencyManager == null) {
            GradleDependencyManager.$$$reportNull$$$0(1);
        }
        return gradleDependencyManager;
    }

    public boolean dependsOn(@NotNull Module module, @NotNull String artifact) {
        AndroidModuleModel gradleModel;
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            GradleDependencyManager.$$$reportNull$$$0(3);
        }
        return (gradleModel = AndroidModuleModel.get(module)) != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(4);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(5);
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (gradleModel == null && buildModel == null) {
            List<GradleCoordinate> list = Collections.emptyList();
            if (list == null) {
                GradleDependencyManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList missingLibraries = Lists.newArrayList();
        for (GradleCoordinate coordinate : dependencies) {
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, null);
            if (resolvedCoordinate == null) {
                if (coordinate.getArtifactId() == null || coordinate.getGroupId() == null) {
                    continue;
                }
            } else {
                coordinate = resolvedCoordinate;
            }
            boolean dependencyFound = false;
            if (gradleModel != null && GradleUtil.dependsOn(gradleModel, String.format("%s:%s", coordinate.getGroupId(), coordinate.getArtifactId()))) {
                dependencyFound = true;
            } else if (buildModel != null) {
                for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts("compile")) {
                    if (!Objects.equal((Object)coordinate.getGroupId(), dependency.group().value()) || !Objects.equal((Object)coordinate.getArtifactId(), (Object)dependency.name().value())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            missingLibraries.add(coordinate);
        }
        ArrayList arrayList = missingLibraries;
        if (arrayList == null) {
            GradleDependencyManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public boolean ensureLibraryIsIncluded(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        List<GradleCoordinate> missing;
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(8);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(9);
        }
        if ((missing = this.findMissingDependencies(module, dependencies)).isEmpty()) {
            return true;
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(buildModel, module, missing, callback);
            return true;
        }
        return false;
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies, @Nullable Runnable callback) {
        GradleBuildModel buildModel;
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(10);
        }
        if (dependencies == null) {
            GradleDependencyManager.$$$reportNull$$$0(11);
        }
        if ((buildModel = GradleBuildModel.get(module)) == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies, callback);
        return true;
    }

    private static boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(12);
        }
        if (missing == null) {
            GradleDependencyManager.$$$reportNull$$$0(13);
        }
        String libraryNames = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private static void addDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(14);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(15);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(16);
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleDependencyManager.addDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$1", "run"));
            }
        }.execute();
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(17);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(18);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(19);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                GradleDependencyManager.$$$reportNull$$$0(29);
            }
            if (coordinates == null) {
                GradleDependencyManager.$$$reportNull$$$0(30);
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                dependenciesModel.addArtifact("compile", coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(20);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(21);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(22);
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$2", "run"));
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(23);
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(true);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, GradleDependencyManager.createSyncListener(callback));
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(24);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(25);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(26);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            if (buildModel == null) {
                GradleDependencyManager.$$$reportNull$$$0(27);
            }
            if (coordinates == null) {
                GradleDependencyManager.$$$reportNull$$$0(28);
            }
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList artifacts = Lists.newArrayList(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().value()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().value()) || gc.getRevision().equals(m.version().value())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    @Nullable
    private static GradleSyncListener createSyncListener(final @Nullable Runnable callback) {
        if (callback == null) {
            return null;
        }
        return new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                callback.run();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                callback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missing";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMissingDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMissingDependencies";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureLibraryIsIncluded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLibrariesToVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "userWantToAddDependencies";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesInTransaction";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesInTransaction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencies";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateDependencies$1";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDependencies$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

