/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.LanguageLevelUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class JavaVersionDslElement
extends GradleDslElement {
    private GradleDslExpression myInternalVersionElement;
    private boolean myUseAssignment;
    @Nullable
    private LanguageLevel myUnsavedValue;

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @NotNull GradleDslExpression dslElement, @NotNull String name) {
        if (dslElement == null) {
            JavaVersionDslElement.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JavaVersionDslElement.$$$reportNull$$$0(1);
        }
        super(parent, null, name);
        assert (dslElement instanceof GradleDslLiteral || dslElement instanceof GradleDslReference);
        if (dslElement.getPsiElement() instanceof GrAssignmentExpression) {
            this.myUseAssignment = true;
        }
        this.myInternalVersionElement = dslElement;
    }

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @NotNull String name, boolean useAssignment) {
        if (name == null) {
            JavaVersionDslElement.$$$reportNull$$$0(2);
        }
        super(parent, null, name);
        this.myUseAssignment = useAssignment;
    }

    public GrExpression getPsiElement() {
        if (this.myInternalVersionElement != null) {
            GroovyPsiElement psiElement = this.myInternalVersionElement.getPsiElement();
            if (psiElement instanceof GrCommandArgumentList) {
                return (GrExpression)psiElement.getParent();
            }
            return (GrExpression)psiElement;
        }
        return null;
    }

    @Override
    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            JavaVersionDslElement.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public LanguageLevel getVersion() {
        if (this.myUnsavedValue != null) {
            return this.myUnsavedValue;
        }
        String text = this.getVersionText();
        if (text != null) {
            return LanguageLevelUtil.parseFromGradleString(text);
        }
        return null;
    }

    @Nullable
    private String getVersionText() {
        GrLiteral literal;
        GradleDslReference referenceElement;
        GradleDslLiteral valueLiteral = null;
        if (this.myInternalVersionElement instanceof GradleDslReference && (valueLiteral = (referenceElement = (GradleDslReference)this.myInternalVersionElement).getValue(GradleDslLiteral.class)) == null) {
            String resolvedReference = referenceElement.getValue(String.class);
            if (resolvedReference != null) {
                return resolvedReference;
            }
            return referenceElement.getReferenceText();
        }
        if (this.myInternalVersionElement instanceof GradleDslLiteral) {
            valueLiteral = (GradleDslLiteral)this.myInternalVersionElement;
        }
        if (valueLiteral != null && (literal = valueLiteral.getLiteral()) != null) {
            return literal.getText();
        }
        return null;
    }

    public void setVersion(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            JavaVersionDslElement.$$$reportNull$$$0(4);
        }
        this.myUnsavedValue = languageLevel;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        GrExpression psiElement = this.getPsiElement();
        if (this.myUnsavedValue == null || psiElement == null) {
            return;
        }
        String groovyString = LanguageLevelUtil.convertToGradleString(this.myUnsavedValue, this.getVersionText());
        GrExpression newVersionPsi = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)groovyString);
        GrExpression oldVersionPsi = this.myUseAssignment ? ((GrAssignmentExpression)psiElement).getRValue() : ((GrApplicationStatement)psiElement).getExpressionArguments()[0];
        assert (oldVersionPsi != null);
        oldVersionPsi.replace((PsiElement)newVersionPsi);
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrExpression valuePsi;
        GrExpression newExpressionPsi;
        GrExpression psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        GradlePropertiesDslElement parent = (GradlePropertiesDslElement)this.myParent;
        assert (parent != null);
        GroovyPsiElement javaPsiElement = parent.create();
        assert (javaPsiElement != null);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)javaPsiElement.getProject());
        JavaVersionDslElement anchor = null;
        if ("sourceCompatibility".equals(this.myName)) {
            anchor = parent.getPropertyElement("targetCompatibility", JavaVersionDslElement.class);
        } else if ("targetCompatibility".equals(this.myName)) {
            anchor = parent.getPropertyElement("sourceCompatibility", JavaVersionDslElement.class);
        }
        GrExpression anchorPsiElement = null;
        String anchorText = null;
        if (anchor != null) {
            anchorPsiElement = anchor.getPsiElement();
            anchorText = anchor.getVersionText();
        }
        if (anchorPsiElement == null) {
            anchorPsiElement = javaPsiElement.getLastChild();
        }
        if (anchorText == null) {
            anchorText = "1.6";
        }
        if (this.myUseAssignment) {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(this.myName + " = " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, (PsiElement)anchorPsiElement);
            valuePsi = ((GrAssignmentExpression)newExpressionPsi).getRValue();
        } else {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(this.myName + " " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, (PsiElement)anchorPsiElement);
            valuePsi = ((GrApplicationStatement)newExpressionPsi).getExpressionArguments()[0];
        }
        if (valuePsi instanceof GrLiteral) {
            this.myInternalVersionElement = new GradleDslLiteral((GradleDslElement)parent, (GroovyPsiElement)newExpressionPsi, this.myName, (GrLiteral)valuePsi);
        } else if (valuePsi instanceof GrReferenceExpression) {
            this.myInternalVersionElement = new GradleDslReference((GradleDslElement)parent, (GroovyPsiElement)newExpressionPsi, this.myName, (GrReferenceExpression)valuePsi);
        }
        return this.getPsiElement();
    }

    @Override
    protected void delete() {
        GrExpression psiElement = this.getPsiElement();
        if (psiElement != null) {
            PsiElement parent = psiElement.getParent();
            psiElement.delete();
            JavaVersionDslElement.deleteIfEmpty(parent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

