/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.gradle.project.build.console.view.GradleConsoleView;
import com.google.common.io.Closeables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.gradle.tooling.BuildLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GradleOutputForwarder {
    private static final int SIZE = 2048;
    @NotNull
    private final ByteArrayOutputStream myStdErr;
    @NotNull
    private final ByteArrayOutputStream myOutput;
    @NotNull
    private final GradleConsoleView myConsoleView;
    private ConsoleViewContentType myPreviousContentType;

    GradleOutputForwarder(@NotNull GradleConsoleView consoleView) {
        if (consoleView == null) {
            GradleOutputForwarder.$$$reportNull$$$0(0);
        }
        this.myConsoleView = consoleView;
        this.myStdErr = new ByteArrayOutputStream(2048);
        this.myOutput = new ByteArrayOutputStream(4096);
    }

    void attachTo(@NotNull BuildLauncher launcher, @Nullable Listener listener) {
        if (launcher == null) {
            GradleOutputForwarder.$$$reportNull$$$0(1);
        }
        ConsoleAwareOutputStream stdout = new ConsoleAwareOutputStream(this, ConsoleViewContentType.NORMAL_OUTPUT, listener);
        ConsoleAwareOutputStream stderr = new ConsoleAwareOutputStream(this, ConsoleViewContentType.ERROR_OUTPUT, listener);
        launcher.setStandardOutput((OutputStream)stdout);
        launcher.setStandardError((OutputStream)stderr);
    }

    void close() {
        try {
            Closeables.close((Closeable)this.myOutput, (boolean)true);
            Closeables.close((Closeable)this.myStdErr, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    String getStdErr() {
        String string = this.myStdErr.toString();
        if (string == null) {
            GradleOutputForwarder.$$$reportNull$$$0(2);
        }
        return string;
    }

    void write(@NotNull ConsoleViewContentType contentType, @NotNull byte[] b, int off, int len) {
        String text;
        if (contentType == null) {
            GradleOutputForwarder.$$$reportNull$$$0(3);
        }
        if (b == null) {
            GradleOutputForwarder.$$$reportNull$$$0(4);
        }
        boolean addNewLine = false;
        if (contentType != this.myPreviousContentType) {
            addNewLine = this.myPreviousContentType != null;
            this.myPreviousContentType = contentType;
        }
        String lineSeparator = SystemProperties.getLineSeparator();
        boolean newLineAdded = false;
        if (addNewLine) {
            byte[] bytes = lineSeparator.getBytes(Charset.forName("UTF-8"));
            this.myOutput.write(bytes, 0, bytes.length);
            this.myConsoleView.print(lineSeparator, contentType);
            newLineAdded = true;
        }
        if (lineSeparator.equals(text = new String(b, off, len)) && newLineAdded) {
            return;
        }
        this.myOutput.write(b, off, len);
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myStdErr.write(b, off, len);
        }
        this.myConsoleView.print(text, contentType);
    }

    public String toString() {
        return this.myOutput.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleOutputForwarder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleOutputForwarder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdErr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attachTo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleAwareOutputStream
    extends OutputStream {
        @NotNull
        private final GradleOutputForwarder myOutput;
        @NotNull
        private final ConsoleViewContentType myContentType;
        @Nullable
        private final Listener myListener;

        ConsoleAwareOutputStream(@NotNull GradleOutputForwarder output, @NotNull ConsoleViewContentType contentType, @Nullable Listener listener) {
            if (output == null) {
                ConsoleAwareOutputStream.$$$reportNull$$$0(0);
            }
            if (contentType == null) {
                ConsoleAwareOutputStream.$$$reportNull$$$0(1);
            }
            this.myOutput = output;
            this.myContentType = contentType;
            this.myListener = listener;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            if (b == null) {
                ConsoleAwareOutputStream.$$$reportNull$$$0(2);
            }
            if (this.myListener != null) {
                this.myListener.onOutput(this.myContentType, b, off, len);
            }
            this.myOutput.write(this.myContentType, b, off, len);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleOutputForwarder$ConsoleAwareOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Listener {
        public void onOutput(@NotNull ConsoleViewContentType var1, @NotNull byte[] var2, int var3, int var4);
    }
}

