/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncLibraryRegistry
implements Disposable {
    @VisibleForTesting
    static final Key<SyncLibraryRegistry> KEY = Key.create((String)"com.android.tools.gradle.sync.ProjectLibraryRegistry");
    private static Factory ourFactory = new Factory();
    @Nullable
    private Project myProject;
    @NotNull
    private final Map<String, Library> myProjectLibrariesByName;
    @NotNull
    private final Set<LibraryToUpdate> myLibrariesToUpdate;

    public static void replaceForTesting(@NotNull Project project, @Nullable SyncLibraryRegistry libraryRegistry) {
        if (project == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(0);
        }
        project.putUserData(KEY, (Object)libraryRegistry);
    }

    @NotNull
    public static SyncLibraryRegistry getInstance(@NotNull Project project) {
        SyncLibraryRegistry registry;
        if (project == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(1);
        }
        if ((registry = (SyncLibraryRegistry)project.getUserData(KEY)) == null || registry.isDisposed()) {
            registry = ourFactory.createNewInstance(project);
            project.putUserData(KEY, (Object)registry);
        }
        SyncLibraryRegistry syncLibraryRegistry = registry;
        if (syncLibraryRegistry == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(2);
        }
        return syncLibraryRegistry;
    }

    SyncLibraryRegistry(@NotNull Project project) {
        if (project == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(3);
        }
        this.myProjectLibrariesByName = new HashMap<String, Library>();
        this.myLibrariesToUpdate = new HashSet<LibraryToUpdate>();
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.registerExistingLibraries();
    }

    private void registerExistingLibraries() {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)this.myProject);
        for (Library library : libraryTable.getLibraries()) {
            String name = library.getName();
            if (name == null) continue;
            this.myProjectLibrariesByName.put(name, library);
        }
    }

    public void markAsUsed(@NotNull Library library, File ... newBinaryPaths) {
        Library used;
        if (library == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(4);
        }
        if (newBinaryPaths == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(5);
        }
        this.checkNotDisposed();
        String name = library.getName();
        if (name != null && (used = this.myProjectLibrariesByName.remove(name)) != null) {
            ArrayList existingBinaryUrls = Lists.newArrayList((Object[])used.getUrls(OrderRootType.CLASSES));
            boolean urlCountChanged = newBinaryPaths.length != existingBinaryUrls.size();
            ArrayList<String> newBinaryUrls = new ArrayList<String>();
            for (File newBinaryPath : newBinaryPaths) {
                String newBinaryUrl = FilePaths.pathToIdeaUrl(newBinaryPath);
                existingBinaryUrls.remove(newBinaryUrl);
                newBinaryUrls.add(newBinaryUrl);
            }
            if (!existingBinaryUrls.isEmpty() || urlCountChanged) {
                LibraryToUpdate libraryToUpdate = new LibraryToUpdate(used, newBinaryUrls);
                this.myLibrariesToUpdate.add(libraryToUpdate);
            }
        }
    }

    @NotNull
    public Collection<Library> getLibrariesToRemove() {
        this.checkNotDisposed();
        Collection<Library> collection = this.myProjectLibrariesByName.values();
        if (collection == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public List<LibraryToUpdate> getLibrariesToUpdate() {
        this.checkNotDisposed();
        ImmutableList immutableList = ImmutableList.copyOf(this.myLibrariesToUpdate);
        if (immutableList == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @VisibleForTesting
    boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        assert (this.myProject != null);
        this.myProject.putUserData(KEY, null);
        this.myProject = null;
        this.myProjectLibrariesByName.clear();
        this.myLibrariesToUpdate.clear();
    }

    @NotNull
    Map<String, Library> getProjectLibrariesByName() {
        Map<String, Library> map = this.myProjectLibrariesByName;
        if (map == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(8);
        }
        return map;
    }

    public static void restoreFactory() {
        SyncLibraryRegistry.setFactory(new Factory());
    }

    public static void setFactory(@NotNull Factory factory) {
        if (factory == null) {
            SyncLibraryRegistry.$$$reportNull$$$0(9);
        }
        ourFactory = factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBinaryPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesToRemove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesToUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLibrariesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceForTesting";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markAsUsed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LibraryToUpdate {
        @NotNull
        private final Library myLibrary;
        @NotNull
        private final Collection<String> myNewBinaryUrls;

        @VisibleForTesting
        public LibraryToUpdate(@NotNull Library library, @NotNull Collection<String> newBinaryUrls) {
            if (library == null) {
                LibraryToUpdate.$$$reportNull$$$0(0);
            }
            if (newBinaryUrls == null) {
                LibraryToUpdate.$$$reportNull$$$0(1);
            }
            this.myLibrary = library;
            this.myNewBinaryUrls = newBinaryUrls;
        }

        @NotNull
        public Library getLibrary() {
            Library library = this.myLibrary;
            if (library == null) {
                LibraryToUpdate.$$$reportNull$$$0(2);
            }
            return library;
        }

        @NotNull
        public Collection<String> getNewBinaryUrls() {
            Collection<String> collection = this.myNewBinaryUrls;
            if (collection == null) {
                LibraryToUpdate.$$$reportNull$$$0(3);
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryToUpdate update = (LibraryToUpdate)o;
            return Objects.equals(this.myLibrary.getName(), update.myLibrary.getName()) && Objects.equals(this.myNewBinaryUrls, update.myNewBinaryUrls);
        }

        public int hashCode() {
            return Objects.hash(this.myLibrary.getName(), this.myNewBinaryUrls);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBinaryUrls";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewBinaryUrls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    public static class Factory {
        @NotNull
        public SyncLibraryRegistry createNewInstance(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            SyncLibraryRegistry syncLibraryRegistry = new SyncLibraryRegistry(project);
            if (syncLibraryRegistry == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return syncLibraryRegistry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

