/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.sync.setup.module.SyncLibraryRegistry;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class AndroidModuleDependenciesSetup
extends ModuleDependenciesSetup {
    @NotNull
    private final LibraryFilePaths myLibraryFilePaths;

    AndroidModuleDependenciesSetup(@NotNull LibraryFilePaths libraryFilePaths) {
        if (libraryFilePaths == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(0);
        }
        this.myLibraryFilePaths = libraryFilePaths;
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath) {
        if (module == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(2);
        }
        if (libraryName == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(4);
        }
        if (artifactPath == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(5);
        }
        this.setUpLibraryDependency(module, modelsProvider, libraryName, scope, artifactPath, new File[]{artifactPath}, ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, @NotNull File[] binaryPaths, @NotNull File[] documentationPaths) {
        if (module == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(7);
        }
        if (libraryName == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(9);
        }
        if (artifactPath == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(10);
        }
        if (binaryPaths == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(11);
        }
        if (documentationPaths == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(12);
        }
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null) {
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        } else {
            SyncLibraryRegistry registry = SyncLibraryRegistry.getInstance(module.getProject());
            registry.markAsUsed(library, binaryPaths);
        }
        if (newLibrary) {
            this.updateLibraryRootTypePaths(library, OrderRootType.CLASSES, modelsProvider, binaryPaths);
            File sourceJarPath = this.myLibraryFilePaths.findSourceJarPath(artifactPath);
            if (sourceJarPath != null) {
                this.updateLibraryRootTypePaths(library, OrderRootType.SOURCES, modelsProvider, sourceJarPath);
            }
            this.updateLibraryRootTypePaths(library, JavadocOrderRootType.getInstance(), modelsProvider, documentationPaths);
            for (File binaryPath : binaryPaths) {
                File annotations;
                String pathName = binaryPath.getName();
                if (pathName.endsWith("res") && pathName.length() > "res".length() && pathName.charAt(pathName.length() - "res".length() - 1) == File.separatorChar) {
                    annotations = new File(pathName.substring(0, pathName.length() - "res".length()), "annotations.zip");
                    if (!annotations.isFile()) continue;
                    this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
                    continue;
                }
                if (!libraryName.startsWith("support-annotations-") || !pathName.endsWith(".jar") || !(annotations = new File(pathName.substring(0, pathName.length() - ".jar".length()) + "-" + "annotations.zip")).isFile()) continue;
                this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
            }
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFilePaths";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationPaths";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpLibraryDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

