/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.SystemProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupErrors myDependencySetupErrors;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(0);
        }
        PostSyncProjectSetup postSyncProjectSetup = (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
        if (postSyncProjectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(1);
        }
        return postSyncProjectSetup;
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull AndroidSdks androidSdks, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull SyncMessages syncMessages, @NotNull DependencySetupErrors dependencySetupErrors, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(2);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(3);
        }
        if (androidSdks == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(4);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(5);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(6);
        }
        if (syncMessages == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(7);
        }
        if (dependencySetupErrors == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(8);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(9);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(10);
        }
        this(project, ideInfo, syncInvoker, syncState, dependencySetupErrors, new ProjectSetup(project), new ModuleSetup(project), new PluginVersionUpgrade(project), versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory());
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupErrors dependencySetupErrors, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(11);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(12);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(13);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(14);
        }
        if (dependencySetupErrors == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(15);
        }
        if (projectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(16);
        }
        if (moduleSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(17);
        }
        if (pluginVersionUpgrade == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(18);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(19);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(20);
        }
        if (moduleValidatorFactory == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(21);
        }
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupErrors = dependencySetupErrors;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
    }

    public void setUpProject(@NotNull Request request, @Nullable ProgressIndicator progressIndicator) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.INSTANCE, false, true));
        boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
        if (syncFailed && request.isUsingCachedGradleModels()) {
            this.onCachedModelsSetupFailure(request);
            return;
        }
        this.myDependencySetupErrors.reportErrors();
        this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
        CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            moduleValidator.validate(module);
        }
        moduleValidator.fixAndReportFoundIssues();
        if (syncFailed) {
            this.myProjectSetup.setUpProject(progressIndicator, true);
            this.mySyncState.syncEnded();
            return;
        }
        if (this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
            return;
        }
        new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
        DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
        Projects.removeAllModuleCompiledArtifacts(this.myProject);
        AndroidGradleProjectComponent.getInstance(this.myProject).checkForSupportedModules();
        this.findAndShowVariantConflicts();
        this.myProjectSetup.setUpProject(progressIndicator, false);
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        String taskName = androidStudio ? "Gradle-aware Make" : ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
        this.setMakeStepInJunitRunConfigurations(taskName);
        this.notifySyncFinished(request);
        this.attemptToGenerateSources(request);
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
        this.myModuleSetup.setUpModules(null);
    }

    private void onCachedModelsSetupFailure(@NotNull Request request) {
        long syncTimestamp;
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(23);
        }
        if ((syncTimestamp = request.getLastSyncTimestamp()) < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, null);
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(24);
        }
        if (request.isUsingCachedGradleModels()) {
            this.mySyncState.syncSkipped(System.currentTimeMillis());
        } else {
            this.mySyncState.syncEnded();
            GradleProjectSyncData.save(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        boolean atLeastOneSolved;
        List<Conflict> selectionConflicts;
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        if (!(selectionConflicts = conflicts.getSelectionConflicts()).isEmpty() && (atLeastOneSolved = ConflictResolution.solveSelectionConflicts(selectionConflicts))) {
            conflicts = ConflictSet.findConflicts(this.myProject);
        }
        conflicts.showSelectionConflicts();
    }

    private void setMakeStepInJunitRunConfigurations(@NotNull String makeTaskName) {
        if (makeTaskName == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(25);
        }
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider : taskProviders) {
            if (!makeTaskName.equals(provider.getName())) continue;
            targetProvider = provider;
            break;
        }
        if (targetProvider != null) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettingsImpl template = runManager.getConfigurationTemplate(configurationFactory);
                RunConfiguration runConfiguration = template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
            for (RunConfiguration runConfiguration : runManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(26);
        }
        if (runConfiguration == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(27);
        }
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task = targetProvider.createTask(runConfiguration);
                if (task == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks, false);
    }

    private void attemptToGenerateSources(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(28);
        }
        if (!request.isGenerateSourcesAfterSync()) {
            return;
        }
        boolean cleanProjectAfterSync = request.isCleanProjectAfterSync();
        if (!cleanProjectAfterSync) {
            Map<String, GradleVersion> previousPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
            Projects.storePluginVersionsPerModule(this.myProject);
            if (previousPluginVersionsPerModule != null && !previousPluginVersionsPerModule.isEmpty()) {
                Map<String, GradleVersion> currentPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                assert (currentPluginVersionsPerModule != null);
                for (Map.Entry<String, GradleVersion> entry : currentPluginVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion previous = previousPluginVersionsPerModule.get(modulePath);
                    if (previous != null && entry.getValue().compareTo(previous) == 0) continue;
                    cleanProjectAfterSync = true;
                    break;
                }
            }
        }
        this.myProjectBuilder.generateSourcesOnly(cleanProjectAfterSync);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySetupErrors";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionCompatibilityChecker";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersionUpgrade";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "makeTaskName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProvider";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onCachedModelsSetupFailure";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifySyncFinished";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJunitRunConfigurations";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJUnitConfiguration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "attemptToGenerateSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        public static final Request DEFAULT_REQUEST = new Request(){

            @Override
            @NotNull
            public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setLastSyncTimestamp(long lastSyncTimestamp) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean myUsingCachedGradleModels;
        private boolean myCleanProjectAfterSync;
        private boolean myGenerateSourcesAfterSync = true;
        private long myLastSyncTimestamp = -1L;

        boolean isUsingCachedGradleModels() {
            return this.myUsingCachedGradleModels;
        }

        @NotNull
        public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
            this.myUsingCachedGradleModels = usingCachedGradleModels;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(0);
            }
            return request;
        }

        boolean isCleanProjectAfterSync() {
            return this.myCleanProjectAfterSync;
        }

        @NotNull
        public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
            this.myCleanProjectAfterSync = cleanProjectAfterSync;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(1);
            }
            return request;
        }

        boolean isGenerateSourcesAfterSync() {
            return this.myGenerateSourcesAfterSync;
        }

        @NotNull
        public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
            this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(2);
            }
            return request;
        }

        long getLastSyncTimestamp() {
            return this.myLastSyncTimestamp;
        }

        @NotNull
        public Request setLastSyncTimestamp(long lastSyncTimestamp) {
            this.myLastSyncTimestamp = lastSyncTimestamp;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(3);
            }
            return request;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUsingCachedGradleModels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCleanProjectAfterSync";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGenerateSourcesAfterSync";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLastSyncTimestamp";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

