/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UniquePathModuleValidatorStrategy
extends CommonProjectValidationStrategy {
    @NotNull
    private final Multimap<String, Module> myModulesByPath;

    UniquePathModuleValidatorStrategy(@NotNull Project project) {
        if (project == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModulesByPath = ArrayListMultimap.create();
    }

    @Override
    void validate(@NotNull Module module) {
        File moduleFolderPath;
        if (module == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(1);
        }
        if ((moduleFolderPath = UniquePathModuleValidatorStrategy.getModuleFilePath(module).getParentFile()) != null) {
            this.myModulesByPath.put((Object)moduleFolderPath.getPath(), (Object)module);
        }
    }

    @NotNull
    private static File getModuleFilePath(@NotNull Module module) {
        if (module == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(2);
        }
        String path = module.getModuleFilePath();
        File file = new File(FileUtil.toSystemDependentName((String)path));
        if (file == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    void fixAndReportFoundIssues() {
        Set modulePaths = this.myModulesByPath.keySet();
        for (String modulePath : modulePaths) {
            DataNode<ProjectData> projectInfo;
            Collection modules = this.myModulesByPath.get((Object)modulePath);
            int moduleCount = modules.size();
            if (moduleCount <= 1) continue;
            StringBuilder msg = new StringBuilder();
            msg.append("The modules [");
            int i = 0;
            HashSet moduleNames = Sets.newHashSet();
            for (Module module : modules) {
                if (i++ != 0) {
                    msg.append(", ");
                }
                String name = module.getName();
                moduleNames.add(name);
                msg.append("'").append(name).append("'");
            }
            msg.append("] point to same directory in the file system.");
            String[] lines = new String[]{msg.toString(), "Each module has to have a unique path."};
            SyncMessage message = new SyncMessage("Project Structure Issues", MessageType.ERROR, lines);
            ArrayList modulesToDisplayInDialog = Lists.newArrayList();
            Project project = this.getProject();
            if (ProjectSubset.getInstance(project).isFeatureEnabled() && (projectInfo = DataNodeCaches.getInstance(project).getCachedProjectData()) != null) {
                Collection cachedModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
                for (DataNode moduleNode : cachedModules) {
                    if (!moduleNames.contains(((ModuleData)moduleNode.getData()).getExternalName())) continue;
                    modulesToDisplayInDialog.add(moduleNode);
                }
            }
            if (!modulesToDisplayInDialog.isEmpty()) {
                message.add(new AddOrRemoveModulesHyperlink());
            }
            SyncMessages.getInstance(project).report(message);
        }
    }

    @VisibleForTesting
    @NotNull
    Multimap<String, Module> getModulesByPath() {
        Multimap<String, Module> multimap = this.myModulesByPath;
        if (multimap == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(4);
        }
        return multimap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFilePath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddOrRemoveModulesHyperlink
    extends NotificationHyperlink {
        AddOrRemoveModulesHyperlink() {
            super("add.or.remove.modules", "Configure Project Subset");
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                AddOrRemoveModulesHyperlink.$$$reportNull$$$0(0);
            }
            ProjectSubset subset = ProjectSubset.getInstance(project);
            subset.addOrRemoveModules();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy$AddOrRemoveModulesHyperlink", "execute"));
        }
    }
}

