/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.structure.configurables.AbstractDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.BasePerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.PsAllModulesFakeModule;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.AndroidModuleDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.ProjectDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.java.dependencies.JavaModuleDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.ui.NamedConfigurable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesPerspectiveConfigurable
extends BasePerspectiveConfigurable {
    @NotNull
    private final Map<String, AbstractDependenciesConfigurable<? extends PsModule>> myConfigurablesByGradlePath;
    @NotNull
    private final List<PsModule> myExtraTopModules;
    @NotNull
    private final Map<PsModule, AbstractDependenciesConfigurable<? extends PsModule>> myExtraTopConfigurables;

    public DependenciesPerspectiveConfigurable(@NotNull PsContext context) {
        if (context == null) {
            DependenciesPerspectiveConfigurable.$$$reportNull$$$0(0);
        }
        super(context);
        this.myConfigurablesByGradlePath = Maps.newHashMap();
        this.myExtraTopModules = Lists.newArrayListWithExpectedSize((int)2);
        this.myExtraTopConfigurables = Maps.newHashMapWithExpectedSize((int)2);
    }

    @Override
    @Nullable
    protected NamedConfigurable<? extends PsModule> getConfigurable(@NotNull PsModule module) {
        AbstractDependenciesConfigurable configurable;
        if (module == null) {
            DependenciesPerspectiveConfigurable.$$$reportNull$$$0(1);
        }
        if (module instanceof PsAllModulesFakeModule) {
            configurable = this.myExtraTopConfigurables.get(module);
            if (configurable == null) {
                configurable = new ProjectDependenciesConfigurable(module, this.getContext(), this.getExtraTopModules());
                ((BaseNamedConfigurable)configurable).setHistory(this.myHistory);
                this.myExtraTopConfigurables.put(module, configurable);
            }
        } else {
            String gradlePath = module.getGradlePath();
            configurable = this.myConfigurablesByGradlePath.get(gradlePath);
            if (configurable == null) {
                if (module instanceof PsAndroidModule) {
                    PsAndroidModule androidModule = (PsAndroidModule)module;
                    configurable = new AndroidModuleDependenciesConfigurable(androidModule, this.getContext(), this.getExtraTopModules());
                    ((BaseNamedConfigurable)configurable).setHistory(this.myHistory);
                    this.myConfigurablesByGradlePath.put(gradlePath, configurable);
                } else if (module instanceof PsJavaModule) {
                    PsJavaModule javaModule = (PsJavaModule)module;
                    configurable = new JavaModuleDependenciesConfigurable(javaModule, this.getContext(), this.getExtraTopModules());
                }
            }
        }
        return configurable;
    }

    @Override
    @NotNull
    protected List<PsModule> getExtraTopModules() {
        if (this.myExtraTopModules.isEmpty()) {
            PsProject project = this.getContext().getProject();
            this.myExtraTopModules.add(new PsAllModulesFakeModule(project));
        }
        List<PsModule> list = this.myExtraTopModules;
        if (list == null) {
            DependenciesPerspectiveConfigurable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    protected String getNavigationPathName() {
        if ("dependencies.place" == null) {
            DependenciesPerspectiveConfigurable.$$$reportNull$$$0(3);
        }
        return "dependencies.place";
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myConfigurablesByGradlePath.clear();
    }

    @NotNull
    public String getId() {
        if ("android.psd.dependencies" == null) {
            DependenciesPerspectiveConfigurable.$$$reportNull$$$0(4);
        }
        return "android.psd.dependencies";
    }

    @Nls
    public String getDisplayName() {
        return "Dependencies";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/DependenciesPerspectiveConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/DependenciesPerspectiveConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraTopModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationPathName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

