/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsBuildTypeCollection
implements PsModelCollection<PsBuildType> {
    @NotNull
    private final Map<String, PsBuildType> myBuildTypesByName;

    PsBuildTypeCollection(@NotNull PsAndroidModule parent) {
        AndroidModel android;
        if (parent == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(0);
        }
        this.myBuildTypesByName = Maps.newHashMap();
        HashMap buildTypesFromGradle = Maps.newHashMap();
        for (BuildTypeContainer container : parent.getGradleModel().getAndroidProject().getBuildTypes()) {
            BuildType buildType = container.getBuildType();
            buildTypesFromGradle.put(buildType.getName(), buildType);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null && (android = parsedModel.android()) != null) {
            List<BuildTypeModel> parsedBuildTypes = android.buildTypes();
            for (BuildTypeModel parsedBuildType : parsedBuildTypes) {
                String name = parsedBuildType.name();
                BuildType fromGradle = (BuildType)buildTypesFromGradle.remove(name);
                PsBuildType model = new PsBuildType(parent, fromGradle, parsedBuildType);
                this.myBuildTypesByName.put(name, model);
            }
        }
        if (!buildTypesFromGradle.isEmpty()) {
            for (BuildType buildType : buildTypesFromGradle.values()) {
                PsBuildType model = new PsBuildType(parent, buildType, null);
                this.myBuildTypesByName.put(buildType.getName(), model);
            }
        }
    }

    @Override
    @Nullable
    public <S extends PsBuildType> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(2);
        }
        if (PsBuildType.class.equals(type)) {
            return (S)((PsBuildType)type.cast(this.myBuildTypesByName.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsBuildType> consumer) {
        if (consumer == null) {
            PsBuildTypeCollection.$$$reportNull$$$0(3);
        }
        this.myBuildTypesByName.values().forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsBuildTypeCollection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

