/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.base.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsDependencyContainer {
    @NotNull
    private final String myVariant;
    @NotNull
    private final String myArtifact;
    @NotNull
    private final String myName;

    PsDependencyContainer(@NotNull PsAndroidArtifact artifact) {
        if (artifact == null) {
            PsDependencyContainer.$$$reportNull$$$0(0);
        }
        PsVariant variant = artifact.getParent();
        this.myVariant = variant.getName();
        this.myArtifact = artifact.getResolvedName();
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    public PsDependencyContainer(@NotNull String variant, @NotNull String artifact) {
        if (variant == null) {
            PsDependencyContainer.$$$reportNull$$$0(1);
        }
        if (artifact == null) {
            PsDependencyContainer.$$$reportNull$$$0(2);
        }
        this.myVariant = variant;
        this.myArtifact = artifact;
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    @NotNull
    private static String createName(@NotNull String variant, @NotNull String artifact) {
        if (variant == null) {
            PsDependencyContainer.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            PsDependencyContainer.$$$reportNull$$$0(4);
        }
        String string = variant + " " + artifact;
        if (string == null) {
            PsDependencyContainer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public PsAndroidArtifact findArtifact(@NotNull PsAndroidModule module, boolean mustExist) {
        PsVariant variant;
        if (module == null) {
            PsDependencyContainer.$$$reportNull$$$0(6);
        }
        if ((variant = module.findVariant(this.myVariant)) == null && !mustExist) {
            return null;
        }
        assert (variant != null);
        PsAndroidArtifact artifact = variant.findArtifact(this.myArtifact);
        if (artifact == null && !mustExist) {
            return null;
        }
        assert (artifact != null);
        return artifact;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsDependencyContainer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getVariant() {
        String string = this.myVariant;
        if (string == null) {
            PsDependencyContainer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getArtifact() {
        String string = this.myArtifact;
        if (string == null) {
            PsDependencyContainer.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsDependencyContainer container = (PsDependencyContainer)o;
        return Objects.equal((Object)this.myVariant, (Object)container.myVariant) && Objects.equal((Object)this.myArtifact, (Object)container.myArtifact);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myVariant, this.myArtifact});
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariant";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createName";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

