/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.navigation;

import com.android.tools.idea.gradle.structure.configurables.DependenciesPerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.navigation.Places;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.common.base.Objects;
import com.intellij.openapi.options.Configurable;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;

public class PsLibraryDependencyNavigationPath
extends PsPath {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myNavigationText;

    public PsLibraryDependencyNavigationPath(@NotNull PsContext context, @NotNull PsLibraryDependency dependency) {
        if (context == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(0);
        }
        if (dependency == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myModuleName = dependency.getParent().getName();
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec == null) {
            spec = dependency.getResolvedSpec();
        }
        this.myNavigationText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION);
        this.myDependency = spec.name + ":" + spec.version;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(2);
        }
        switch (type) {
            case PLAIN_TEXT: {
                String string = this.myDependency;
                if (string == null) {
                    PsLibraryDependencyNavigationPath.$$$reportNull$$$0(3);
                }
                return string;
            }
            case HTML: {
                String string = this.getHtmlText();
                if (string == null) {
                    PsLibraryDependencyNavigationPath.$$$reportNull$$$0(4);
                }
                return string;
            }
            case FOR_COMPARE_TO: {
                String string = this.myDependency + " / " + this.myModuleName;
                if (string == null) {
                    PsLibraryDependencyNavigationPath.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ("" == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(6);
        }
        return "";
    }

    @NotNull
    private String getHtmlText() {
        Place place = new Place();
        ProjectStructureConfigurable mainConfigurable = this.myContext.getMainConfigurable();
        DependenciesPerspectiveConfigurable target = mainConfigurable.findConfigurable(DependenciesPerspectiveConfigurable.class);
        assert (target != null);
        ProjectStructureConfigurable.putPath(place, (Configurable)target);
        target.putNavigationPath(place, this.myModuleName, this.myNavigationText);
        String href = "psdGoTo://" + Places.serialize(place);
        String string = String.format("<a href='%1$s'>%2$s</a> (%3$s)", href, this.myDependency, this.myModuleName);
        if (string == null) {
            PsLibraryDependencyNavigationPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryDependencyNavigationPath that = (PsLibraryDependencyNavigationPath)o;
        return Objects.equal((Object)this.myModuleName, (Object)that.myModuleName) && Objects.equal((Object)this.myDependency, (Object)that.myDependency) && Objects.equal((Object)this.myNavigationText, (Object)that.myNavigationText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myModuleName, this.myDependency, this.myNavigationText});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/navigation/PsLibraryDependencyNavigationPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/navigation/PsLibraryDependencyNavigationPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

