/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");

    private GradleUtil() {
    }

    @NotNull
    public static Collection<File> getGeneratedSourceFolders(@NotNull BaseArtifact artifact) {
        List<File> list;
        if (artifact == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        try {
            List<File> folders = artifact.getGeneratedSourceFolders();
            list = folders != null ? folders : Collections.emptyList();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            List<File> list2 = Collections.emptyList();
            if (list2 == null) {
                GradleUtil.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (list == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static Dependencies getDependencies(@NotNull BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            GradleUtil.$$$reportNull$$$0(3);
        }
        Dependencies dependencies = artifact.getDependencies();
        if (dependencies == null) {
            GradleUtil.$$$reportNull$$$0(4);
        }
        return dependencies;
    }

    public static boolean androidModelSupportsInstantApps(@NotNull GradleVersion modelVersion) {
        if (modelVersion == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        return modelVersion.compareIgnoringQualifiers("2.3.0") >= 0;
    }

    public static void clearStoredGradleJvmArgs(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (project == null) {
                    GradleUtil.$$$reportNull$$$0(53);
                }
                String jvmArgs = existingJvmArgs.trim();
                String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    try {
                        GradleProperties gradleProperties = new GradleProperties(project);
                        gradleProperties.setJvmArgs(jvmArgs);
                        gradleProperties.save();
                    }
                    catch (IOException e) {
                        String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                        LOG.info(err, (Throwable)e);
                        String cause = e.getMessage();
                        if (StringUtil.isNotEmpty((String)cause)) {
                            err = err + String.format("<br>\nCause: %1$s", cause);
                        }
                        AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                    }
                } else {
                    String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                    AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion) {
        GradleVersion supported;
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(7);
        }
        return (supported = GradleVersion.parse((String)"3.3")).compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            GradleUtil.$$$reportNull$$$0(8);
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            GradleUtil.$$$reportNull$$$0(9);
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(10);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            int projectType = androidModel.getProjectType();
            if (projectType == 0 || projectType == 4) {
                Icon icon = AndroidIcons.AppModule;
                if (icon == null) {
                    GradleUtil.$$$reportNull$$$0(11);
                }
                return icon;
            }
            Icon icon = AndroidIcons.LibraryModule;
            if (icon == null) {
                GradleUtil.$$$reportNull$$$0(12);
            }
            return icon;
        }
        Icon icon = AndroidProjectInfo.getInstance(module.getProject()).requiresAndroidModel() ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
        if (icon == null) {
            GradleUtil.$$$reportNull$$$0(13);
        }
        return icon;
    }

    @Nullable
    public static AndroidProject getAndroidProject(@NotNull Module module) {
        AndroidModuleModel gradleModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(14);
        }
        return (gradleModel = AndroidModuleModel.get(module)) != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        NdkModuleModel ndkModuleModel;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(15);
        }
        return (ndkModuleModel = NdkModuleModel.get(module)) != null ? ndkModuleModel.getAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        GradleFacet facet;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(16);
        }
        return (facet = GradleFacet.getInstance(module)) != null ? ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(17);
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<AndroidLibrary> getDirectLibraryDependencies(@NotNull Variant variant, @NotNull AndroidModuleModel androidModel) {
        if (variant == null) {
            GradleUtil.$$$reportNull$$$0(18);
        }
        if (androidModel == null) {
            GradleUtil.$$$reportNull$$$0(19);
        }
        ArrayList libraries = Lists.newArrayList();
        GradleVersion modelVersion = androidModel.getModelVersion();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)mainArtifact, modelVersion);
        libraries.addAll(dependencies.getLibraries());
        for (BaseArtifact testArtifact : AndroidModuleModel.getTestArtifacts(variant)) {
            dependencies = GradleUtil.getDependencies(testArtifact, modelVersion);
            libraries.addAll(dependencies.getLibraries());
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            GradleUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(21);
        }
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(22);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(23);
        }
        List list = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
        if (list == null) {
            GradleUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        GradleFacet gradleFacet;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(25);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) != null && gradleFacet.getGradleModuleModel() != null) {
            return gradleFacet.getGradleModuleModel().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(26);
        }
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(27);
        }
        File file = new File(dirPath, "build.gradle");
        if (file == null) {
            GradleUtil.$$$reportNull$$$0(28);
        }
        return file;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(29);
        }
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(30);
        }
        File file = new File(dirPath, "settings.gradle");
        if (file == null) {
            GradleUtil.$$$reportNull$$$0(31);
        }
        return file;
    }

    @Nullable
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project, boolean useEmbeddedGradle) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(32);
        }
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && useEmbeddedGradle && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            File jdkPath = IdeSdks.getInstance().getJdkPath();
            if (jdkPath != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(33);
        }
        if ((projectSettings = GradleUtil.getGradleProjectSettings(project)) == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(34);
        }
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(35);
        }
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        String string = FileUtil.join((String[])ArrayUtil.toStringArray(segments));
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        if (parentDir == null) {
            GradleUtil.$$$reportNull$$$0(37);
        }
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(38);
        }
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
        if (file == null) {
            GradleUtil.$$$reportNull$$$0(39);
        }
        return file;
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(40);
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath, boolean checkProjectFolder) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(41);
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(42);
        }
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            AndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getModelVersion();
            if (androidModel.getProjectType() == 0) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(43);
        }
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = gradleWrapper.getProperties();
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(44);
        }
        return gradleVersion.equals("3.3") || gradleVersion.equals("3.3");
    }

    public static boolean dependsOn(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedMainCompileDependencies();
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    @Nullable
    public static GradleVersion getModuleDependencyVersion(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedMainCompileDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String version = GradleUtil.getDependencyVersion(library, artifact, true);
            if (version == null) continue;
            return GradleVersion.tryParse((String)version);
        }
        return null;
    }

    public static boolean dependsOnAndroidTest(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedAndroidTestCompileDependencies();
        if (dependencies == null) {
            return false;
        }
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    private static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        return GradleUtil.getDependencyVersion(library, artifact, transitively) != null;
    }

    private static String getDependencyVersion(AndroidLibrary library, String artifact, boolean transitively) {
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.endsWith(resolvedCoordinates.getArtifactId()) && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getVersion();
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                String version = GradleUtil.getDependencyVersion(dependency, artifact, true);
                if (version == null) continue;
                return version;
            }
        }
        return null;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        if (e == null) {
            GradleUtil.$$$reportNull$$$0(45);
        }
        if (causeClass == null) {
            GradleUtil.$$$reportNull$$$0(46);
        }
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    public static void setBuildToolsVersion(@NotNull Project project, @NotNull String version) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(47);
        }
        if (version == null) {
            GradleUtil.$$$reportNull$$$0(48);
        }
        ArrayList modelsToUpdate = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModel android;
            GradleBuildModel buildModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (buildModel = GradleBuildModel.get(module)) == null || (android = buildModel.android()) == null || version.equals(android.buildToolsVersion().value())) continue;
            android.setBuildToolsVersion(version);
            modelsToUpdate.add(buildModel);
        }
        if (!modelsToUpdate.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (GradleBuildModel buildModel : modelsToUpdate) {
                    buildModel.applyChanges();
                }
            });
        }
    }

    @Nullable
    public static AndroidLibrary findLibrary(@NotNull File bundleDir, @NotNull Variant variant, @Nullable GradleVersion modelVersion) {
        if (bundleDir == null) {
            GradleUtil.$$$reportNull$$$0(49);
        }
        if (variant == null) {
            GradleUtil.$$$reportNull$$$0(50);
        }
        AndroidArtifact artifact = variant.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)artifact, modelVersion);
        for (AndroidLibrary library : dependencies.getLibraries()) {
            AndroidLibrary result = GradleUtil.findLibrary(library, bundleDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static AndroidLibrary findLibrary(@NotNull AndroidLibrary library, @NotNull File bundleDir) {
        if (library == null) {
            GradleUtil.$$$reportNull$$$0(51);
        }
        if (bundleDir == null) {
            GradleUtil.$$$reportNull$$$0(52);
        }
        if (FileUtil.filesEqual((File)bundleDir, (File)library.getFolder())) {
            return library;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AndroidLibrary result = GradleUtil.findLibrary(dependency, bundleDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelVersion";
                break;
            }
            case 6: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 43: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 22: 
            case 23: 
            case 35: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "causeClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleDir";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourceFolders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIcon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectLibraryDependencies";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSegments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleBuildFilePath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleSettingsFilePath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPhysicalPathFromGradlePath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDefaultPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedSourceFolders";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "androidModelSupportsInstantApps";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearStoredGradleJvmArgs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedGradleVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOutput";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIcon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGradlePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleWithNoSources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDirectLibraryDependencies";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByGradlePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPathSegments";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFilePath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFilePath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGradleExecutionSettings";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGradleExecutionSettings";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGradleProjectSettings";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPhysicalPathFromGradlePath";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDefaultPath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isValidGradlePath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasModule";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidGradleModelVersionInUse";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "attemptToUseEmbeddedGradle";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWithEmbeddedGradleVersion";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasCause";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setBuildToolsVersion";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$clearStoredGradleJvmArgs$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

