/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidLintOldTargetApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintOldTargetApiInspection() {
        super(AndroidBundle.message("android.lint.inspections.old.target.api", new Object[0]), ManifestDetector.TARGET_NEWER);
    }

    private static int getHighestApi(PsiElement element) {
        AndroidSdkData sdkData;
        int max = 25;
        AndroidFacet instance = AndroidFacet.getInstance(element);
        if (instance != null && (sdkData = instance.getSdkData()) != null) {
            for (IAndroidTarget target : sdkData.getTargets()) {
                AndroidVersion version;
                if (!target.isPlatform() || (version = target.getVersion()).getApiLevel() <= max || version.isPreview()) continue;
                max = version.getApiLevel();
            }
        }
        return max;
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintOldTargetApiInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintOldTargetApiInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintOldTargetApiInspection.$$$reportNull$$$0(2);
        }
        String highest = Integer.toString(AndroidLintOldTargetApiInspection.getHighestApi(startElement));
        String label = "Update targetSdkVersion to " + highest;
        if (startElement.getContainingFile() instanceof XmlFile) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, "targetSdkVersion\\s*=\\s*[\"'](.*)[\"']", highest)};
            if (androidLintQuickFixArray == null) {
                AndroidLintOldTargetApiInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        if (startElement.getContainingFile() instanceof GroovyFile) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, null, highest)};
            if (androidLintQuickFixArray == null) {
                AndroidLintOldTargetApiInspection.$$$reportNull$$$0(4);
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            AndroidLintOldTargetApiInspection.$$$reportNull$$$0(5);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintOldTargetApiInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

