/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.model.MemoryDataCache;
import com.android.tools.idea.monitor.ui.memory.model.MemoryInfoTreeNode;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassHistogramView
extends BaseSegment
implements Disposable {
    private static final String NAME = "Memory Details";
    private static final Color NEGATIVE_COLOR = new JBColor(new Color(0x33FF0000, true), new Color(872375396, true));
    private static final Color POSITIVE_COLOR = new JBColor(new Color(0x330000FF, true), new Color(861445622, true));
    @NotNull
    private final JPanel myParent;
    @NotNull
    private MemoryInfoTreeNode myRoot;
    @Nullable
    private HeapDump myMainHeapDump;
    @Nullable
    private HeapDump myDiffHeapDump;
    private JComponent myColumnTree;
    private JTree myTree;
    private DefaultTreeModel myTreeModel;

    ClassHistogramView(@NotNull Disposable parentDisposable, @NotNull JPanel parentPanel, @NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull EventDispatcher<ProfilerEventListener> profilerEventDispatcher) {
        if (parentDisposable == null) {
            ClassHistogramView.$$$reportNull$$$0(0);
        }
        if (parentPanel == null) {
            ClassHistogramView.$$$reportNull$$$0(1);
        }
        if (timeCurrentRangeUs == null) {
            ClassHistogramView.$$$reportNull$$$0(2);
        }
        if (choreographer == null) {
            ClassHistogramView.$$$reportNull$$$0(3);
        }
        if (profilerEventDispatcher == null) {
            ClassHistogramView.$$$reportNull$$$0(4);
        }
        super(NAME, timeCurrentRangeUs, profilerEventDispatcher);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myParent = parentPanel;
        this.myRoot = new MemoryInfoTreeNode("Root");
        ArrayList<Animatable> animatables = new ArrayList<Animatable>();
        this.createComponentsList(animatables);
        choreographer.register(animatables);
        this.initializeComponents();
        this.myParent.add((Component)this, "Center");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(ClassHistogramView.class);
        if (logger == null) {
            ClassHistogramView.$$$reportNull$$$0(5);
        }
        return logger;
    }

    void generateClassHistogramFromHeapDumpInfos(@NotNull MemoryDataCache dataCache, @Nullable MemoryProfiler.HeapDumpInfo mainHeapDumpInfo, @Nullable MemoryProfiler.HeapDumpInfo diffHeapDumpInfo) {
        int instanceCount;
        String className;
        if (dataCache == null) {
            ClassHistogramView.$$$reportNull$$$0(6);
        }
        if (this.myMainHeapDump == null || this.myMainHeapDump.getInfo() != mainHeapDumpInfo) {
            if (this.myMainHeapDump != null) {
                this.myMainHeapDump.dispose();
                this.myMainHeapDump = null;
            }
            if (mainHeapDumpInfo != null) {
                try {
                    this.myMainHeapDump = new HeapDump(dataCache, mainHeapDumpInfo);
                }
                catch (IOException exception) {
                    ClassHistogramView.getLog().info("Error generating Snapshot from heap dump file.", (Throwable)exception);
                    return;
                }
            }
        }
        if (this.myDiffHeapDump == null || this.myDiffHeapDump.getInfo() != diffHeapDumpInfo) {
            if (this.myDiffHeapDump != null) {
                this.myDiffHeapDump.dispose();
                this.myDiffHeapDump = null;
            }
            if (diffHeapDumpInfo != null) {
                try {
                    this.myDiffHeapDump = new HeapDump(dataCache, diffHeapDumpInfo);
                }
                catch (IOException exception) {
                    ClassHistogramView.getLog().info("Error generating Snapshot from heap dump file.", (Throwable)exception);
                    return;
                }
            }
        }
        HeapDump positiveHeapDump = this.myDiffHeapDump != null ? this.myDiffHeapDump : this.myMainHeapDump;
        HeapDump negativeHeapDump = this.myDiffHeapDump != null ? this.myMainHeapDump : null;
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        if (positiveHeapDump != null) {
            for (Heap heap : positiveHeapDump.mySnapshot.getHeaps()) {
                for (ClassObj classObj : heap.getClasses()) {
                    className = classObj.getClassName();
                    instanceCount = classObj.getInstanceCount() + instanceMap.getOrDefault(className, 0);
                    instanceMap.put(className, instanceCount);
                }
            }
        }
        if (negativeHeapDump != null) {
            for (Heap heap : negativeHeapDump.mySnapshot.getHeaps()) {
                for (ClassObj classObj : heap.getClasses()) {
                    className = classObj.getClassName();
                    instanceCount = instanceMap.getOrDefault(className, 0) - classObj.getInstanceCount();
                    instanceMap.put(className, instanceCount);
                }
            }
        }
        this.generateClassHistogram(instanceMap);
    }

    boolean generateClassHistogramFromAllocationTracking(@NotNull AllocationTrackingSample sample) {
        if (sample == null) {
            ClassHistogramView.$$$reportNull$$$0(7);
        }
        if (this.myMainHeapDump != null) {
            this.myMainHeapDump.dispose();
            this.myMainHeapDump = null;
        }
        if (this.myDiffHeapDump != null) {
            this.myDiffHeapDump.dispose();
            this.myDiffHeapDump = null;
        }
        ByteBuffer data = ByteBuffer.wrap(sample.getData());
        data.order(ByteOrder.BIG_ENDIAN);
        if (AllocationsParser.hasOverflowedNumEntriesBug((ByteBuffer)data)) {
            ClassHistogramView.getLog().info("Allocations file has overflow bug.");
            return false;
        }
        AllocationInfo[] allocationInfos = AllocationsParser.parse((ByteBuffer)data);
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (AllocationInfo info : allocationInfos) {
            instanceMap.put(info.getAllocatedClass(), instanceMap.getOrDefault(info.getAllocatedClass(), 0) + 1);
        }
        this.generateClassHistogram(instanceMap);
        return true;
    }

    private void generateClassHistogram(@NotNull Map<String, Integer> instanceMap) {
        if (instanceMap == null) {
            ClassHistogramView.$$$reportNull$$$0(8);
        }
        this.myRoot.setCount(0);
        this.myRoot.removeAllChildren();
        int maxInstanceCount = Integer.MIN_VALUE;
        for (Map.Entry<String, Integer> entry : instanceMap.entrySet()) {
            int instanceCount = entry.getValue();
            if (instanceCount == 0) continue;
            MemoryInfoTreeNode child = new MemoryInfoTreeNode(entry.getKey());
            child.setCount(instanceCount);
            this.insertNode(this.myRoot, child);
            maxInstanceCount = Math.max(maxInstanceCount, Math.abs(instanceCount));
        }
        this.myRoot.setCount(maxInstanceCount);
        this.refreshNode(this.myRoot);
    }

    public void dispose() {
        if (this.myMainHeapDump != null) {
            this.myMainHeapDump.dispose();
            this.myMainHeapDump = null;
        }
        if (this.myDiffHeapDump != null) {
            this.myDiffHeapDump.dispose();
            this.myDiffHeapDump = null;
        }
        this.myParent.remove(this);
    }

    public void refreshNode(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            ClassHistogramView.$$$reportNull$$$0(9);
        }
        this.myTreeModel.reload(node);
    }

    public boolean getExpandState(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            ClassHistogramView.$$$reportNull$$$0(10);
        }
        return this.myTree.isExpanded(new TreePath(this.myTreeModel.getPathToRoot(node)));
    }

    public void setExpandState(@NotNull MemoryInfoTreeNode node, boolean expand) {
        if (node == null) {
            ClassHistogramView.$$$reportNull$$$0(11);
        }
        if (expand) {
            this.myTree.expandPath(new TreePath(this.myTreeModel.getPathToRoot(node)));
        } else {
            this.myTree.collapsePath(new TreePath(this.myTreeModel.getPathToRoot(node)));
        }
    }

    public void insertNode(@NotNull MemoryInfoTreeNode parent, @NotNull MemoryInfoTreeNode child) {
        if (parent == null) {
            ClassHistogramView.$$$reportNull$$$0(12);
        }
        if (child == null) {
            ClassHistogramView.$$$reportNull$$$0(13);
        }
        this.myTreeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            ClassHistogramView.$$$reportNull$$$0(14);
        }
        panel.add((Component)this.myColumnTree, "Center");
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            ClassHistogramView.$$$reportNull$$$0(15);
        }
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(0, this.myRoot))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(1, this.myRoot)).setInitialOrder(SortOrder.DESCENDING).setComparator((a, b) -> a.getCount() - b.getCount()));
        builder.setTreeSorter((comparator, sortOrder) -> {
            this.myRoot.sort(comparator);
            this.myTreeModel.nodeStructureChanged(this.myRoot);
        });
        this.myColumnTree = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerEventDispatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/ClassHistogramView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceMap";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/ClassHistogramView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateClassHistogramFromHeapDumpInfos";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateClassHistogramFromAllocationTracking";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateClassHistogram";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpandState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setExpandState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCenterContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createComponentsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HeapDump {
        @NotNull
        private final MemoryProfiler.HeapDumpInfo myInfo;
        @NotNull
        private final Snapshot mySnapshot;

        public HeapDump(@NotNull MemoryDataCache dataCache, @NotNull MemoryProfiler.HeapDumpInfo info) throws IOException {
            if (dataCache == null) {
                HeapDump.$$$reportNull$$$0(0);
            }
            if (info == null) {
                HeapDump.$$$reportNull$$$0(1);
            }
            this.myInfo = info;
            this.mySnapshot = Snapshot.createSnapshot((DataBuffer)new InMemoryBuffer(dataCache.getHeapDumpData(info).asReadOnlyByteBuffer()));
        }

        @NotNull
        public MemoryProfiler.HeapDumpInfo getInfo() {
            MemoryProfiler.HeapDumpInfo heapDumpInfo = this.myInfo;
            if (heapDumpInfo == null) {
                HeapDump.$$$reportNull$$$0(2);
            }
            return heapDumpInfo;
        }

        public void dispose() {
            this.mySnapshot.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/ClassHistogramView$HeapDump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/ClassHistogramView$HeapDump";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MemoryInfoHealthBar
    extends JComponent {
        private float mDelta;

        private MemoryInfoHealthBar() {
        }

        private void setDelta(float delta) {
            this.mDelta = delta;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getSize();
            if (this.mDelta > 0.0f) {
                g.setColor(NEGATIVE_COLOR);
            } else {
                g.setColor(POSITIVE_COLOR);
            }
            g.fillRect(0, 0, (int)((float)dim.width * Math.abs(this.mDelta)), dim.height);
        }
    }

    private static class MemoryInfoColumnRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final MemoryInfoHealthBar mHealthBar;
        @NotNull
        private final MemoryInfoTreeNode mRoot;
        private final int mColumnIndex;

        private MemoryInfoColumnRenderer(int index, @NotNull MemoryInfoTreeNode root) {
            if (root == null) {
                MemoryInfoColumnRenderer.$$$reportNull$$$0(0);
            }
            this.mHealthBar = new MemoryInfoHealthBar();
            this.mColumnIndex = index;
            this.mRoot = root;
            if (this.mColumnIndex > 0) {
                this.setLayout(new BorderLayout());
                this.add(this.mHealthBar, "Center");
            }
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MemoryInfoColumnRenderer.$$$reportNull$$$0(1);
            }
            if (value instanceof MemoryInfoTreeNode) {
                MemoryInfoTreeNode node = (MemoryInfoTreeNode)value;
                switch (this.mColumnIndex) {
                    case 0: {
                        this.append(node.getName());
                        break;
                    }
                    case 1: {
                        this.append(String.valueOf(node.getCount()));
                    }
                }
                this.mHealthBar.setDelta((float)node.getCount() / (float)this.mRoot.getCount());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/ClassHistogramView$MemoryInfoColumnRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

