/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchableAndroidDevice
implements AndroidDevice {
    private static final Map<Abi, List<Abi>> ABI_MAPPINGS = ImmutableMap.of((Object)Abi.X86_64, (Object)ImmutableList.of((Object)Abi.X86_64, (Object)Abi.X86), (Object)Abi.ARM64_V8A, (Object)ImmutableList.of((Object)Abi.ARM64_V8A, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARMEABI));
    private final AvdInfo myAvdInfo;
    private final Object LOCK;
    private ListenableFuture<IDevice> myLaunchedEmulator;

    public LaunchableAndroidDevice(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myAvdInfo = avdInfo;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = this.myAvdInfo.getAndroidVersion();
        if (androidVersion == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(1);
        }
        return androidVersion;
    }

    @Override
    public int getDensity() {
        String s = (String)this.myAvdInfo.getProperties().get("hw.lcd.density");
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        Abi abi = Abi.getEnum((String)this.myAvdInfo.getAbiType());
        if (abi == null) {
            List<Abi> list = Collections.emptyList();
            if (list == null) {
                LaunchableAndroidDevice.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Abi> abis = ABI_MAPPINGS.get(abi);
        if (abis != null) {
            List<Abi> list = abis;
            if (list == null) {
                LaunchableAndroidDevice.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Abi> list = Collections.singletonList(abi);
        if (list == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public String getSerial() {
        String string = this.myAvdInfo.getName();
        if (string == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        if (feature == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(6);
        }
        switch (feature) {
            case WATCH: {
                return SystemImage.WEAR_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case TV: {
                return SystemImage.TV_TAG.equals((Object)this.myAvdInfo.getTag());
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AvdManagerConnection.getAvdDisplayName(this.myAvdInfo);
        if (string == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void renderName(@NotNull SimpleColoredComponent renderer, boolean isCompatible, @Nullable String searchPrefix) {
        if (renderer == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(8);
        }
        renderer.setIcon(AndroidIcons.Ddms.EmulatorDevice);
        SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        SearchUtil.appendFragments((String)searchPrefix, (String)this.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        if (project == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(9);
        }
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myLaunchedEmulator == null) {
            this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(project, this.myAvdInfo);
        }
        ListenableFuture<IDevice> listenableFuture = this.myLaunchedEmulator;
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        LaunchableAndroidDevice.$$$reportNull$$$0(10);
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myLaunchedEmulator == null) {
            throw new IllegalStateException("Attempt to get device corresponding to an emulator that hasn't been launched yet.");
        }
        ListenableFuture<IDevice> listenableFuture = this.myLaunchedEmulator;
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        LaunchableAndroidDevice.$$$reportNull$$$0(11);
        return listenableFuture;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(12);
        }
        if (projectTarget == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(13);
        }
        if (requiredFeatures == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(14);
        }
        LaunchCompatibility compatibility = LaunchCompatibility.YES;
        if (this.myAvdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            compatibility = AvdManagerConnection.isSystemImageDownloadProblem(this.myAvdInfo.getStatus()) ? new LaunchCompatibility(ThreeState.UNSURE, "Missing system image") : new LaunchCompatibility(ThreeState.NO, this.myAvdInfo.getErrorMessage());
        }
        LaunchCompatibility launchCompatibility = compatibility.combine(LaunchCompatibility.canRunOnDevice(minSdkVersion, projectTarget, requiredFeatures, supportedAbis, this));
        if (launchCompatibility == null) {
            LaunchableAndroidDevice.$$$reportNull$$$0(15);
        }
        return launchCompatibility;
    }

    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/LaunchableAndroidDevice";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdkVersion";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTarget";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/LaunchableAndroidDevice";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbis";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerial";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "launch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchedDevice";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "canRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsFeature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

