/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class ServiceContext {
    private final Map<String, ObservableValue> myValues;
    private final Map<String, Runnable> myActions;
    private final Map<AbstractProperty, Object> myWatched;
    private final BoolValueProperty myInstalled;
    private final BoolValueProperty myModified;
    private final BoolValueProperty myHiddenFromStructureDialog;
    private final InvalidationListener myWatchedListener;
    @NotNull
    private final String myBuildSystemId;
    private Runnable myBeforeShown;
    private Callable<Boolean> myTestValidity;

    public ServiceContext(@NotNull String buildSystemId) {
        if (buildSystemId == null) {
            ServiceContext.$$$reportNull$$$0(0);
        }
        this.myValues = Maps.newHashMap();
        this.myActions = Maps.newHashMap();
        this.myWatched = new WeakHashMap<AbstractProperty, Object>();
        this.myInstalled = new BoolValueProperty();
        this.myModified = new BoolValueProperty();
        this.myHiddenFromStructureDialog = new BoolValueProperty();
        this.myWatchedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                ServiceContext.this.myModified.set(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/structure/services/ServiceContext$1", "onInvalidated"));
            }
        };
        this.myBeforeShown = EmptyRunnable.INSTANCE;
        this.myTestValidity = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        };
        this.myBuildSystemId = buildSystemId;
    }

    @NotNull
    String getBuildSystemId() {
        String string = this.myBuildSystemId;
        if (string == null) {
            ServiceContext.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setBeforeShownCallback(@NotNull Runnable beforeShown) {
        if (beforeShown == null) {
            ServiceContext.$$$reportNull$$$0(2);
        }
        this.myBeforeShown = beforeShown;
    }

    public void setIsValidCallback(@NotNull Callable<Boolean> testValidity) {
        if (testValidity == null) {
            ServiceContext.$$$reportNull$$$0(3);
        }
        this.myTestValidity = testValidity;
    }

    public void beginEditing() {
        this.myBeforeShown.run();
        if (this.myWatched.isEmpty()) {
            this.myModified.set(this.isValid());
        }
    }

    public void finishEditing() {
        if (!this.myModified.get().booleanValue()) {
            return;
        }
        this.myModified.set(this.isValid());
    }

    public void cancelEditing() {
        this.myModified.set(false);
    }

    public BoolValueProperty installed() {
        return this.myInstalled;
    }

    public ObservableBool modified() {
        return this.myModified;
    }

    public BoolValueProperty hiddenFromStructureDialog() {
        return this.myHiddenFromStructureDialog;
    }

    public void snapshot() {
        for (AbstractProperty property : this.myWatched.keySet()) {
            this.myWatched.put(property, property.get());
        }
        this.myModified.set(false);
    }

    public void restore() {
        for (AbstractProperty property : this.myWatched.keySet()) {
            property.set(this.myWatched.get(property));
        }
        this.myModified.set(false);
    }

    public void putValue(@NotNull String key, @NotNull ObservableValue value) {
        if (key == null) {
            ServiceContext.$$$reportNull$$$0(4);
        }
        if (value == null) {
            ServiceContext.$$$reportNull$$$0(5);
        }
        this.myValues.put(key, value);
    }

    public void putWatchedValue(@NotNull String key, @NotNull AbstractProperty property) {
        if (key == null) {
            ServiceContext.$$$reportNull$$$0(6);
        }
        if (property == null) {
            ServiceContext.$$$reportNull$$$0(7);
        }
        this.putValue(key, property);
        property.addWeakListener(this.myWatchedListener);
        this.myWatched.put(property, property.get());
    }

    public void putAction(@NotNull String key, @NotNull Runnable action) {
        if (key == null) {
            ServiceContext.$$$reportNull$$$0(8);
        }
        if (action == null) {
            ServiceContext.$$$reportNull$$$0(9);
        }
        this.myActions.put(key, action);
    }

    @NotNull
    public ObservableValue getValue(@NotNull String key) {
        ObservableValue value;
        if (key == null) {
            ServiceContext.$$$reportNull$$$0(10);
        }
        if ((value = this.myValues.get(key)) == null) {
            throw new IllegalArgumentException(String.format("Service context: Value \"%1$s\" not found.", key));
        }
        ObservableValue observableValue = value;
        if (observableValue == null) {
            ServiceContext.$$$reportNull$$$0(11);
        }
        return observableValue;
    }

    @NotNull
    public Runnable getAction(@NotNull String key) {
        Runnable action;
        if (key == null) {
            ServiceContext.$$$reportNull$$$0(12);
        }
        if ((action = this.myActions.get(key)) == null) {
            throw new IllegalArgumentException(String.format("Service context: Action \"%1$s\" not found.", key));
        }
        Runnable runnable = action;
        if (runnable == null) {
            ServiceContext.$$$reportNull$$$0(13);
        }
        return runnable;
    }

    @NotNull
    public Map<String, Object> toValueMap() {
        HashMap valueMap = Maps.newHashMap();
        Splitter splitter = Splitter.on((char)'.');
        for (String key : this.myValues.keySet()) {
            ObservableValue value = this.getValue(key);
            Map currLevel = valueMap;
            Iterator keyParts = splitter.split((CharSequence)key).iterator();
            while (keyParts.hasNext()) {
                String keyPart = (String)keyParts.next();
                if (keyParts.hasNext()) {
                    if (currLevel.containsKey(keyPart)) {
                        currLevel = (Map)currLevel.get(keyPart);
                        continue;
                    }
                    HashMap nextLevel = Maps.newHashMap();
                    currLevel.put(keyPart, nextLevel);
                    currLevel = nextLevel;
                    continue;
                }
                currLevel.put(keyPart, value);
            }
        }
        HashMap hashMap = valueMap;
        if (hashMap == null) {
            ServiceContext.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private boolean isValid() {
        try {
            return this.myTestValidity.call();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSystemId";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/services/ServiceContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeShown";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testValidity";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/services/ServiceContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystemId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeShownCallback";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIsValidCallback";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putWatchedValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

