/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyPanelDefinition;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeDefinition;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends WorkBench<DesignSurface> {
    private final VirtualFile myFile;
    private final DesignSurface mySurface;
    private final Project myProject;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        if (editor == null) {
            NlEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NlEditorPanel.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            NlEditorPanel.$$$reportNull$$$0(2);
        }
        if (file == null) {
            NlEditorPanel.$$$reportNull$$$0(3);
        }
        super(project, "NELE_EDITOR", (FileEditor)editor);
        this.setOpaque(true);
        this.myProject = project;
        this.myFile = file;
        this.mySurface = new DesignSurface(project, false);
        Disposer.register((Disposable)editor, (Disposable)this.mySurface);
        NlModel model = NlModel.create(this.mySurface, (Disposable)editor, facet, file);
        this.mySurface.setModel(model);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JComponent toolbarComponent = this.mySurface.getActionManager().createToolbar(model);
        contentPanel.add((Component)toolbarComponent, "North");
        contentPanel.add(this.mySurface);
        ArrayList<ToolWindowDefinition> tools = new ArrayList<ToolWindowDefinition>(4);
        tools.add(new NlPaletteDefinition(project, Side.LEFT, Split.TOP, AutoHide.DOCKED));
        tools.add(new NlComponentTreeDefinition(Side.LEFT, Split.BOTTOM, AutoHide.DOCKED));
        tools.add(new NlPropertyPanelDefinition(project, Side.RIGHT, Split.TOP, AutoHide.DOCKED));
        this.init(contentPanel, this.mySurface, tools);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myFile);
        assert (file != null);
        XmlFile xmlFile = file;
        if (xmlFile == null) {
            NlEditorPanel.$$$reportNull$$$0(4);
        }
        return xmlFile;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            NlEditorPanel.$$$reportNull$$$0(5);
        }
        return designSurface;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlEditorPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NlConfigurationHolder
    implements ConfigurationHolder {
        @NotNull
        private final DesignSurface mySurface;

        public NlConfigurationHolder(@NotNull DesignSurface surface) {
            if (surface == null) {
                NlConfigurationHolder.$$$reportNull$$$0(0);
            }
            this.mySurface = surface;
        }

        @Override
        @Nullable
        public Configuration getConfiguration() {
            return this.mySurface.getConfiguration();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlEditorPanel$NlConfigurationHolder", "<init>"));
        }
    }
}

