/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.utils.Pair;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull List<NlComponent> components) {
        AndroidFacet facet;
        if (components == null) {
            NlProperties.$$$reportNull$$$0(0);
        }
        if ((facet = NlProperties.getFacet(components)) == null) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(1);
            }
            return immutableTable;
        }
        GradleDependencyManager dependencyManager = GradleDependencyManager.getInstance(facet.getModule().getProject());
        Table<String, String, NlPropertyItem> table = this.getProperties(facet, components, dependencyManager);
        if (table == null) {
            NlProperties.$$$reportNull$$$0(2);
        }
        return table;
    }

    Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(3);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(4);
        }
        if (dependencyManager == null) {
            NlProperties.$$$reportNull$$$0(5);
        }
        return (Table)ApplicationManager.getApplication().runReadAction(() -> {
            if (facet == null) {
                NlProperties.$$$reportNull$$$0(39);
            }
            if (components == null) {
                NlProperties.$$$reportNull$$$0(40);
            }
            if (dependencyManager == null) {
                NlProperties.$$$reportNull$$$0(41);
            }
            return this.getPropertiesWithReadLock(facet, components, dependencyManager);
        });
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesWithReadLock(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(6);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(7);
        }
        if (dependencyManager == null) {
            NlProperties.$$$reportNull$$$0(8);
        }
        LocalResourceManager localResourceManager = facet.getLocalResourceManager();
        SystemResourceManager systemResourceManager = facet.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(9);
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        for (NlComponent component : components) {
            XmlTag tag = component.getTag();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(10);
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(11);
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                String namespace = NlProperties.getNamespace(desc, tag);
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(namespace) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(desc.getName());
                NlPropertyItem property = NlPropertyItem.create(components, desc, namespace, attrDef);
                properties.put((Object)StringUtil.notNullize((String)namespace), (Object)property.getName(), (Object)property);
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(components, new AndroidAnyAttributeDescriptor("popupBackground"), "http://schemas.android.com/apk/res/android", systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.setUpSrcCompat(combinedProperties, facet, components, dependencyManager);
        NlProperties.initStarState(combinedProperties);
        Table<String, String, NlPropertyItem> table = combinedProperties;
        if (table == null) {
            NlProperties.$$$reportNull$$$0(12);
        }
        return table;
    }

    @Nullable
    private static AndroidFacet getFacet(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlProperties.$$$reportNull$$$0(13);
        }
        if (components.isEmpty()) {
            return null;
        }
        NlComponent first = components.get(0);
        XmlTag firstTag = first.getTag();
        return AndroidFacet.getInstance((PsiElement)firstTag);
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(14);
        }
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property.getFirst(), property.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(15);
        }
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        StringBuilder builder = new StringBuilder();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            builder.append(starredProperty);
            builder.append(";");
        }
        if (starred) {
            builder.append(propertyNameWithPrefix);
            builder.append(";");
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, builder.toString());
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(16);
        }
        if (namespace == null) {
            String string = propertyName;
            if (string == null) {
                NlProperties.$$$reportNull$$$0(17);
            }
            return string;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                String string = "tools:" + propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(18);
                }
                return string;
            }
            case "http://schemas.android.com/apk/res/android": {
                String string = propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        String string = "app:" + propertyName;
        if (string == null) {
            NlProperties.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix == null) {
            NlProperties.$$$reportNull$$$0(21);
        }
        if (propertyNameWithPrefix.startsWith("tools:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(22);
            }
            return pair;
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(23);
            }
            return pair;
        }
        Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
        if (pair == null) {
            NlProperties.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @Nullable
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            NlProperties.$$$reportNull$$$0(25);
        }
        if (context == null) {
            NlProperties.$$$reportNull$$$0(26);
        }
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            return ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return null;
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(27);
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(28);
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static void setUpSrcCompat(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        NlPropertyItem srcProperty;
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(29);
        }
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(30);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(31);
        }
        if (dependencyManager == null) {
            NlProperties.$$$reportNull$$$0(32);
        }
        if ((srcProperty = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)"src")) != null && NlProperties.shouldAddSrcCompat(facet, components, dependencyManager)) {
            AttributeDefinition srcDefinition = srcProperty.getDefinition();
            assert (srcDefinition != null);
            AttributeDefinition srcCompatDefinition = new AttributeDefinition("srcCompat", null, srcDefinition.getFormats());
            srcCompatDefinition.getParentStyleables().addAll(srcDefinition.getParentStyleables());
            NlPropertyItem srcCompatProperty = new NlPropertyItem(components, "http://schemas.android.com/apk/res-auto", srcCompatDefinition);
            properties.put((Object)"http://schemas.android.com/apk/res-auto", (Object)"srcCompat", (Object)srcCompatProperty);
        }
    }

    private static boolean shouldAddSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull GradleDependencyManager dependencyManager) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(33);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(34);
        }
        if (dependencyManager == null) {
            NlProperties.$$$reportNull$$$0(35);
        }
        return dependencyManager.dependsOn(facet.getModule(), "com.android.support:appcompat-v7") && NlProperties.allComponentsAreImageViews(facet, components) && NlProperties.currentActivityIfFoundIsDerivedFromAppCompatActivity(components);
    }

    private static boolean allComponentsAreImageViews(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(36);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(37);
        }
        ViewHandlerManager manager = ViewHandlerManager.get(facet);
        if (components.isEmpty()) {
            return false;
        }
        for (NlComponent component : components) {
            ViewHandler handler = manager.getHandler(component.getTagName());
            if (handler instanceof ImageViewHandler) continue;
            return false;
        }
        return true;
    }

    private static boolean currentActivityIfFoundIsDerivedFromAppCompatActivity(@NotNull List<NlComponent> components) {
        PsiClass activityClass;
        if (components == null) {
            NlProperties.$$$reportNull$$$0(38);
        }
        assert (!components.isEmpty());
        NlModel model = components.get(0).getModel();
        Configuration configuration = model.getConfiguration();
        String activityClassName = configuration.getActivity();
        if (activityClassName == null) {
            return true;
        }
        if (activityClassName.startsWith(".")) {
            MergedManifest manifest = MergedManifest.get(model.getModule());
            String pkg = StringUtil.notNullize((String)manifest.getPackage());
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)model.getProject());
        for (activityClass = facade.findClass(activityClassName, model.getModule().getModuleScope()); activityClass != null && !"android.support.v7.app.AppCompatActivity".equals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 3: 
            case 6: 
            case 30: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: 
            case 32: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 14: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameWithPrefix";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesWithReadLock";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameWithPrefix";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesWithReadLock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFacet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initStarState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveStarState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameWithPrefix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setUpDesignProperties";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setUpSrcCompat";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddSrcCompat";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "allComponentsAreImageViews";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "currentActivityIfFoundIsDerivedFromAppCompatActivity";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProperties$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

