/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.config;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkDetection {
    private static final AtomicBoolean myJdkDetectionInProgress = new AtomicBoolean();

    private JdkDetection() {
    }

    public static void start(JdkDetectionResult result) {
        new DetectJdkTask(result, true).queue();
    }

    public static void startWithProgressIndicator(JdkDetectionResult result) {
        new DetectJdkTask(result, false).queue();
    }

    @Nullable
    public static String validateJdkLocation(@Nullable File location) {
        if (location == null) {
            return "Path is empty";
        }
        if (!JdkUtil.checkForJdk((File)location)) {
            return "Path specified is not a valid JDK location";
        }
        if (!JdkDetection.isJdk7(location)) {
            return "JDK 7.0 or newer is required";
        }
        return null;
    }

    private static boolean isJdk7(@NotNull File path) {
        JavaSdkVersion version;
        String jdkVersion;
        if (path == null) {
            JdkDetection.$$$reportNull$$$0(0);
        }
        return (jdkVersion = SdkVersionUtil.detectJdkVersion((String)path.getAbsolutePath())) == null || (version = JavaSdk.getInstance().getVersion(jdkVersion)) == null || version.isAtLeast(JavaSdkVersion.JDK_1_7);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/config/JdkDetection", "isJdk7"));
    }

    private static class DetectJdkTask
    extends Task.Modal {
        private static final String MAC_JDKS_DIR = "/Library/Java/JavaVirtualMachines/";
        private static final String WINDOWS_JDKS_DIR = "C:\\Program Files\\Java";
        private static final String LINUX_SDK_DIR = "/usr/lib/jvm";
        private final JdkDetectionResult myResult;
        private final boolean myHeadless;
        private String myPath = null;

        public DetectJdkTask(JdkDetectionResult result, boolean headless) {
            super(null, "Detect JDK", true);
            this.myResult = result;
            this.myHeadless = headless;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                DetectJdkTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            if (myJdkDetectionInProgress.compareAndSet(false, true)) {
                try {
                    this.myPath = DetectJdkTask.detectJdkPath(indicator);
                }
                finally {
                    myJdkDetectionInProgress.set(false);
                }
            }
            while (myJdkDetectionInProgress.get()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isHeadless() {
            if (this.myHeadless) {
                return false;
            }
            return super.isHeadless();
        }

        public void onSuccess() {
            this.myResult.onSuccess(this.myPath);
        }

        public void onCancel() {
            this.myResult.onCancel();
        }

        public void onThrowable(@NotNull Throwable error) {
            if (error == null) {
                DetectJdkTask.$$$reportNull$$$0(1);
            }
            super.onThrowable(error);
            this.myResult.onCancel();
        }

        @Nullable
        private static String detectJdkPath(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                DetectJdkTask.$$$reportNull$$$0(2);
            }
            String topVersion = null;
            String chosenPath = null;
            for (String path : DetectJdkTask.getCandidatePaths()) {
                indicator.checkCanceled();
                if (!StringUtil.isEmpty((String)JdkDetection.validateJdkLocation(new File(path)))) continue;
                String version = JavaSdk.getInstance().getVersionString(path);
                if (topVersion != null && version != null && topVersion.compareTo(version) >= 0) continue;
                topVersion = version;
                chosenPath = path;
            }
            return chosenPath;
        }

        @NotNull
        private static Iterable<String> getCandidatePaths() {
            Iterable iterable = Iterables.concat(DetectJdkTask.deduceFromJavaHome(), DetectJdkTask.deduceFromPath(), DetectJdkTask.deduceFromCurrentJvm(), DetectJdkTask.getOsSpecificCandidatePaths());
            if (iterable == null) {
                DetectJdkTask.$$$reportNull$$$0(3);
            }
            return iterable;
        }

        @NotNull
        private static Iterable<String> deduceFromJavaHome() {
            String javaHome = System.getenv("JAVA_HOME");
            Set<Object> set = Strings.isNullOrEmpty((String)javaHome) ? Collections.emptySet() : Collections.singleton(javaHome);
            if (set == null) {
                DetectJdkTask.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        private static Iterable<String> deduceFromPath() {
            String[] pathEntries;
            String path = System.getenv("PATH");
            if (Strings.isNullOrEmpty((String)path)) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    DetectJdkTask.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (String entry : pathEntries = path.split(File.pathSeparator)) {
                Iterable<String> iterable;
                if (Strings.isNullOrEmpty((String)entry)) continue;
                File javaParentDir = new File(entry);
                File javaFile = new File(javaParentDir, "java");
                if (!javaParentDir.isDirectory() || !javaFile.isFile()) continue;
                try {
                    File canonicalJavaFile = javaFile.getCanonicalFile();
                    iterable = DetectJdkTask.forJavaBinParent(canonicalJavaFile.getParentFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (iterable == null) {
                    DetectJdkTask.$$$reportNull$$$0(6);
                }
                return iterable;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                DetectJdkTask.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        private static Iterable<String> deduceFromCurrentJvm() {
            String javaHome = System.getProperty("java.home");
            Iterable<String> iterable = Strings.isNullOrEmpty((String)javaHome) ? Collections.emptySet() : DetectJdkTask.forJavaBinParent(new File(javaHome));
            if (iterable == null) {
                DetectJdkTask.$$$reportNull$$$0(8);
            }
            return iterable;
        }

        @NotNull
        private static Iterable<String> forJavaBinParent(@NotNull File javaBinParent) {
            if (javaBinParent == null) {
                DetectJdkTask.$$$reportNull$$$0(9);
            }
            if (!javaBinParent.isDirectory()) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    DetectJdkTask.$$$reportNull$$$0(10);
                }
                return set;
            }
            if (!"jre".equals(javaBinParent.getName())) {
                Set<String> set = Collections.singleton(javaBinParent.getAbsolutePath());
                if (set == null) {
                    DetectJdkTask.$$$reportNull$$$0(11);
                }
                return set;
            }
            File parentFile = javaBinParent.getParentFile();
            if (parentFile.isDirectory()) {
                Set<String> set = Collections.singleton(parentFile.getAbsolutePath());
                if (set == null) {
                    DetectJdkTask.$$$reportNull$$$0(12);
                }
                return set;
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DetectJdkTask.$$$reportNull$$$0(13);
            }
            return set;
        }

        @NotNull
        private static Iterable<String> getOsSpecificCandidatePaths() {
            if (SystemInfo.isMac) {
                Iterable<String> iterable = DetectJdkTask.getMacCandidateJdks();
                if (iterable == null) {
                    DetectJdkTask.$$$reportNull$$$0(14);
                }
                return iterable;
            }
            if (SystemInfo.isWindows) {
                Iterable<String> iterable = DetectJdkTask.getWindowsCandidateJdks();
                if (iterable == null) {
                    DetectJdkTask.$$$reportNull$$$0(15);
                }
                return iterable;
            }
            if (SystemInfo.isLinux) {
                Iterable<String> iterable = DetectJdkTask.getLinuxCandidateJdks();
                if (iterable == null) {
                    DetectJdkTask.$$$reportNull$$$0(16);
                }
                return iterable;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                DetectJdkTask.$$$reportNull$$$0(17);
            }
            return list;
        }

        @NotNull
        private static Iterable<String> getMacCandidateJdks() {
            Iterable<String> iterable = DetectJdkTask.getCandidatePaths(MAC_JDKS_DIR, "/Contents/Home");
            if (iterable == null) {
                DetectJdkTask.$$$reportNull$$$0(18);
            }
            return iterable;
        }

        @NotNull
        private static Iterable<String> getWindowsCandidateJdks() {
            Iterable<String> iterable = DetectJdkTask.getCandidatePaths(WINDOWS_JDKS_DIR, "");
            if (iterable == null) {
                DetectJdkTask.$$$reportNull$$$0(19);
            }
            return iterable;
        }

        @NotNull
        private static Iterable<String> getLinuxCandidateJdks() {
            Iterable<String> iterable = DetectJdkTask.getCandidatePaths(LINUX_SDK_DIR, "");
            if (iterable == null) {
                DetectJdkTask.$$$reportNull$$$0(20);
            }
            return iterable;
        }

        private static Iterable<String> getCandidatePaths(String basedir, final String suffix) {
            final File location = new File(basedir);
            if (location.isDirectory()) {
                return Iterables.transform(Arrays.asList(location.list()), (Function)new Function<String, String>(){

                    public String apply(@Nullable String dir) {
                        return new File(location, dir + suffix).getAbsolutePath();
                    }
                });
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/welcome/config/JdkDetection$DetectJdkTask";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaBinParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/welcome/config/JdkDetection$DetectJdkTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCandidatePaths";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deduceFromJavaHome";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deduceFromPath";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deduceFromCurrentJvm";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forJavaBinParent";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOsSpecificCandidatePaths";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMacCandidateJdks";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowsCandidateJdks";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinuxCandidateJdks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onThrowable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "detectJdkPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "forJavaBinParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface JdkDetectionResult {
        public void onSuccess(String var1);

        public void onCancel();
    }
}

