/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import org.jetbrains.android.exportSignedPackage.NewKeyForm;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.SaveFileListener;
import org.jetbrains.annotations.NotNull;

public class NewKeyStoreDialog
extends DialogWrapper {
    private JPanel myNewKeyPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myKeyStorePathField;
    private JPasswordField myPasswordField;
    private JPasswordField myConfirmedPassword;
    private final NewKeyForm myNewKeyForm;
    private final Project myProject;

    public NewKeyStoreDialog(@NotNull Project project, @NotNull String defaultKeyStorePath) {
        if (project == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(0);
        }
        if (defaultKeyStorePath == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myKeyStorePathField.setText(defaultKeyStorePath);
        this.setTitle("New Key Store");
        this.myNewKeyForm = new MyNewKeyForm();
        this.myNewKeyPanel.add((Component)this.myNewKeyForm.getContentPanel(), "Center");
        this.myKeyStorePathField.addActionListener((ActionListener)new SaveFileListener(this.myPanel, this.myKeyStorePathField, AndroidBundle.message("android.extract.package.choose.keystore.title", new Object[0]), "jks"){

            @Override
            protected String getDefaultLocation() {
                return NewKeyStoreDialog.this.getKeyStorePath();
            }
        });
        this.init();
    }

    protected void init() {
        super.init();
        this.myPasswordField.setName("myPasswordField");
        this.myConfirmedPassword.setName("myConfirmedPassword");
        this.myNewKeyForm.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeyStorePathField;
    }

    protected void doOKAction() {
        if (this.getKeyStorePath().length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Specify key store path", (String)CommonBundle.getErrorTitle());
            return;
        }
        try {
            AndroidUtils.checkNewPassword(this.myPasswordField, this.myConfirmedPassword);
            this.myNewKeyForm.createKey();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        super.doOKAction();
    }

    @NotNull
    public String getKeyStorePath() {
        String string = this.myKeyStorePathField.getText().trim();
        if (string == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public char[] getKeyStorePassword() {
        char[] cArray = this.myPasswordField.getPassword();
        if (cArray == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(3);
        }
        return cArray;
    }

    @NotNull
    public String getKeyAlias() {
        String string = this.myNewKeyForm.getKeyAlias();
        if (string == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public char[] getKeyPassword() {
        char[] cArray = this.myNewKeyForm.getKeyPassword();
        if (cArray == null) {
            NewKeyStoreDialog.$$$reportNull$$$0(5);
        }
        return cArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultKeyStorePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/NewKeyStoreDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/NewKeyStoreDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStorePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStorePassword";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyAlias";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyPassword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key store path:");
        jBLabel.setDisplayedMnemonic('K');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKeyStorePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myNewKeyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Key", (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Confirm:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmedPassword = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel2.setLabelFor(jPasswordField2);
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyNewKeyForm
    extends NewKeyForm {
        private MyNewKeyForm() {
        }

        @Override
        protected List<String> getExistingKeyAliasList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        protected Project getProject() {
            Project project = NewKeyStoreDialog.this.myProject;
            if (project == null) {
                MyNewKeyForm.$$$reportNull$$$0(0);
            }
            return project;
        }

        @Override
        @NotNull
        protected char[] getKeyStorePassword() {
            char[] cArray = NewKeyStoreDialog.this.getKeyStorePassword();
            if (cArray == null) {
                MyNewKeyForm.$$$reportNull$$$0(1);
            }
            return cArray;
        }

        @Override
        @NotNull
        protected String getKeyStoreLocation() {
            String string = NewKeyStoreDialog.this.getKeyStorePath();
            if (string == null) {
                MyNewKeyForm.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/android/compiler/artifact/NewKeyStoreDialog$MyNewKeyForm";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyStorePassword";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyStoreLocation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

