/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.model.MergedManifest;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;

    public InstantAppUrlFinder(@NotNull MergedManifest manifest) {
        if (manifest == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(0);
        }
        this(manifest.getActivities());
    }

    InstantAppUrlFinder(@NotNull Collection<Element> activities) {
        if (activities == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(1);
        }
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                for (UrlData urlData : wrapper.getAllUrlData()) {
                    allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
                }
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)allUrls.values());
        if (immutableList == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            String string = (String)urls.iterator().next();
            if (string == null) {
                InstantAppUrlFinder.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("" == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(4);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/InstantAppUrlFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/InstantAppUrlFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUrls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UrlData {
        private final String myScheme;
        private final String myHost;
        private final String myPathPattern;

        @NotNull
        public static UrlData of(@NotNull Node node) {
            if (node == null) {
                UrlData.$$$reportNull$$$0(0);
            }
            String scheme = "";
            String host = "";
            String pathPattern = "";
            if (node.getNodeType() == 1 && "data".equals(node.getNodeName())) {
                Element element = (Element)node;
                scheme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme");
                host = element.getAttributeNS("http://schemas.android.com/apk/res/android", "host");
                pathPattern = element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern");
            }
            UrlData urlData = new UrlData(scheme, host, pathPattern);
            if (urlData == null) {
                UrlData.$$$reportNull$$$0(1);
            }
            return urlData;
        }

        public UrlData(String scheme, String host, String pathPattern) {
            this.myScheme = scheme;
            this.myHost = host;
            this.myPathPattern = pathPattern;
        }

        @NotNull
        public static String convertPatternToExample(String pattern) {
            String string = pattern.replace(".*", "parameter").replace("?", "X");
            if (string == null) {
                UrlData.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isValid() {
            return StringUtil.isNotEmpty((String)this.myScheme) && StringUtil.isNotEmpty((String)this.myHost) && StringUtil.isNotEmpty((String)this.myPathPattern);
        }

        @NotNull
        public String getUrl() {
            String string = String.format("%s://%s/%s", this.myScheme, this.myHost, UrlData.convertPatternToExample(this.myPathPattern));
            if (string == null) {
                UrlData.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/util/InstantAppUrlFinder$UrlData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/util/InstantAppUrlFinder$UrlData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertPatternToExample";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class InstantAppIntentFilterWrapper {
        @Nullable
        private final Element myElement;
        private final int myOrder;

        private InstantAppIntentFilterWrapper(@Nullable Element element, int order) {
            this.myElement = element;
            this.myOrder = order;
        }

        @NotNull
        public static InstantAppIntentFilterWrapper of(@NotNull Node node) {
            int order;
            Element element;
            if (node == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(0);
            }
            try {
                element = InstantAppIntentFilterWrapper.getElement(node);
                order = InstantAppIntentFilterWrapper.getOrder(element);
            }
            catch (IllegalArgumentException unused) {
                element = null;
                order = -1;
            }
            InstantAppIntentFilterWrapper instantAppIntentFilterWrapper = new InstantAppIntentFilterWrapper(element, order);
            if (instantAppIntentFilterWrapper == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(1);
            }
            return instantAppIntentFilterWrapper;
        }

        @NotNull
        public static Element getElement(@NotNull Node node) {
            if (node == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(2);
            }
            if (node.getNodeType() == 1 && "intent-filter".equals(node.getNodeName())) {
                Element element = (Element)node;
                if (element == null) {
                    InstantAppIntentFilterWrapper.$$$reportNull$$$0(3);
                }
                return element;
            }
            throw new IllegalArgumentException();
        }

        public static int getOrder(@NotNull Element element) {
            if (element == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(4);
            }
            String orderValue = element.getAttributeNS("http://schemas.android.com/instantapps", "order");
            try {
                return Integer.parseUnsignedInt(orderValue);
            }
            catch (NumberFormatException unused) {
                throw new IllegalArgumentException();
            }
        }

        @NotNull
        public Collection<UrlData> getAllUrlData() {
            if (this.myElement == null) {
                List<UrlData> list = Collections.emptyList();
                if (list == null) {
                    InstantAppIntentFilterWrapper.$$$reportNull$$$0(5);
                }
                return list;
            }
            ArrayList<UrlData> allUrls = new ArrayList<UrlData>();
            for (Node node = this.myElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                UrlData data = UrlData.of(node);
                if (!data.isValid()) continue;
                allUrls.add(data);
            }
            ArrayList<UrlData> arrayList = allUrls;
            if (arrayList == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        public int getOrder() {
            return this.myOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/util/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUrlData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

