/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class PropertyKeyReferenceProvider
extends PsiReferenceProvider {
    private final boolean myTagMode;
    private final String myFallbackKeyName;
    private final String myFallbackGroupName;

    public PropertyKeyReferenceProvider(boolean tagMode, String fallbackKeyName, String fallbackGroupName) {
        this.myTagMode = tagMode;
        this.myFallbackKeyName = fallbackKeyName;
        this.myFallbackGroupName = fallbackGroupName;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            PropertyKeyReferenceProvider.$$$reportNull$$$0(0);
        }
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            PropertyKeyReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PropertyKeyReferenceProvider.$$$reportNull$$$0(2);
        }
        if (this.myTagMode && element instanceof XmlTag) {
            PsiReference[] psiReferenceArray = this.getTagReferences((XmlTag)element);
            if (psiReferenceArray == null) {
                PropertyKeyReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttribute xmlAttribute = (XmlAttribute)element.getParent();
            if (element.getTextLength() < 2) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    PropertyKeyReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            XmlTag tag = xmlAttribute.getParent();
            String value = null;
            String bundle = tag.getAttributeValue("bundle");
            if ("key".equals(xmlAttribute.getName())) {
                value = xmlAttribute.getValue();
            } else if (this.myFallbackKeyName.equals(xmlAttribute.getName())) {
                value = xmlAttribute.getValue();
                String groupBundle = tag.getAttributeValue(this.myFallbackGroupName);
                if (groupBundle != null) {
                    bundle = groupBundle;
                }
            }
            if (value != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyPropertyReference(value, (PsiElement)xmlAttribute.getValueElement(), bundle)};
                if (psiReferenceArray == null) {
                    PropertyKeyReferenceProvider.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PropertyKeyReferenceProvider.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private PsiReference[] getTagReferences(XmlTag element) {
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag groupNameTag = parent.findFirstSubTag(this.myFallbackGroupName);
        String bundleName = groupNameTag != null ? groupNameTag.getValue().getTrimmedText() : null;
        return new PsiReference[]{new MyPropertyReference(element.getValue().getText(), (PsiElement)element, bundleName)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPropertyReference
    extends PropertyReference {
        @Nullable
        private final String myBundleName;

        private MyPropertyReference(String value, PsiElement psiElement, @Nullable String bundleName) {
            super(value, psiElement, bundleName, false);
            this.myBundleName = bundleName;
        }

        @Nullable
        protected List<PropertiesFile> getPropertiesFiles() {
            return this.retrievePropertyFilesByBundleName(this.myBundleName, this.getElement());
        }

        protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
            String bundleNameToUse;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return Collections.emptyList();
            }
            String string = bundleNameToUse = bundleName == null ? MyPropertyReference.getPluginResourceBundle(element) : bundleName;
            if (bundleNameToUse == null) {
                return Collections.emptyList();
            }
            Project project = element.getProject();
            PropertiesReferenceManager propertiesReferenceManager = PropertiesReferenceManager.getInstance((Project)project);
            ArrayList<PropertiesFile> allPropertiesFiles = new ArrayList<PropertiesFile>();
            List propertiesFiles = propertiesReferenceManager.findPropertiesFiles(module, bundleNameToUse);
            allPropertiesFiles.addAll(propertiesFiles);
            if (propertiesFiles.isEmpty()) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
                allPropertiesFiles.addAll(propertiesReferenceManager.findPropertiesFiles(projectScope, bundleNameToUse, BundleNameEvaluator.DEFAULT));
            }
            return allPropertiesFiles;
        }

        @Nullable
        private static String getPluginResourceBundle(PsiElement element) {
            DomElement domElement = DomUtil.getDomElement((PsiElement)element);
            if (domElement == null) {
                return null;
            }
            DomElement rootElement = DomUtil.getFileElement((DomElement)domElement).getRootElement();
            if (!(rootElement instanceof IdeaPlugin)) {
                return null;
            }
            IdeaPlugin plugin = (IdeaPlugin)rootElement;
            return plugin.getResourceBundle().getStringValue();
        }
    }
}

