/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import icons.DevkitIcons;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdkConfigurable;
import org.jetbrains.idea.devkit.projectRoots.IntelliJPlatformProduct;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class IdeaJdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.projectRoots.IdeaJdk");
    @NonNls
    private static final String LIB_DIR_NAME = "lib";
    @NonNls
    private static final String SRC_DIR_NAME = "src";
    @NonNls
    private static final String PLUGINS_DIR = "plugins";

    public IdeaJdk() {
        super("IDEA JDK");
    }

    public Icon getIcon() {
        return DevkitIcons.Sdk_closed;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.idea" == null) {
            IdeaJdk.$$$reportNull$$$0(0);
        }
        return "reference.project.structure.sdk.idea";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = DevkitIcons.Add_sdk;
        if (icon == null) {
            IdeaJdk.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public String suggestHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        File home;
        if (homePath == null) {
            IdeaJdk.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isMac && (home = new File(homePath, "Contents")).exists()) {
            String string = home.getPath();
            if (string == null) {
                IdeaJdk.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = super.adjustSelectedSdkHome(homePath);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        if (IdeaJdk.isFromIDEAProject(path)) {
            return true;
        }
        File home = new File(path);
        return home.exists() && IdeaJdk.getBuildNumber(path) != null && IdeaJdk.getOpenApiJar(path) != null;
    }

    @Nullable
    private static File getOpenApiJar(String home) {
        String openapiJar = "openapi.jar";
        File libDir = new File(home, LIB_DIR_NAME);
        File f = new File(libDir, "openapi.jar");
        if (f.exists()) {
            return f;
        }
        f = new File(libDir, "platform-api.jar");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static boolean isFromIDEAProject(String path) {
        File ultimate = new File(path, "idea.iml");
        File community = new File(path, "community-main.iml");
        return ultimate.exists() && ultimate.isFile() || community.exists() && community.isFile();
    }

    @Nullable
    public final String getVersionString(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(5);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    private static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof Sandbox) {
            return ((Sandbox)data).getJavaSdk();
        }
        return null;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        if (IdeaJdk.isFromIDEAProject(sdkHome)) {
            return "Local IDEA [" + sdkHome + "]";
        }
        String buildNumber = IdeaJdk.getBuildNumber(sdkHome);
        return IntelliJPlatformProduct.fromBuildNumber(buildNumber).getName() + " " + (buildNumber != null ? buildNumber : "");
    }

    @Nullable
    public static String getBuildNumber(String ideaHome) {
        try {
            String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
            File file = new File(ideaHome, buildTxt);
            if (SystemInfo.isMac && !file.exists()) {
                file = new File(ideaHome, "build.txt");
            }
            return FileUtil.loadFile((File)file).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static VirtualFile[] getIdeaLibrary(String home) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        IdeaJdk.appendIdeaLibrary(home, result, "junit.jar");
        String plugins = home + File.separator + PLUGINS_DIR + File.separator;
        IdeaJdk.appendIdeaLibrary(plugins + "JavaEE", result, "javaee-impl.jar", "jpa-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "PersistenceSupport", result, "persistence-impl.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "DatabaseTools", result, "database-impl.jar", "jdbc-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "css", result, "css.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "uml", result, "uml-support.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "Spring", result, "spring.jar", "spring-el.jar", "spring-jsf.jar", "spring-persistence-integration.jar");
        return VfsUtilCore.toVirtualFileArray(result);
    }

    private static void appendIdeaLibrary(@NotNull String libDirPath, @NotNull List<VirtualFile> result, String ... forbidden) {
        File[] jars;
        if (libDirPath == null) {
            IdeaJdk.$$$reportNull$$$0(6);
        }
        if (result == null) {
            IdeaJdk.$$$reportNull$$$0(7);
        }
        if (forbidden == null) {
            IdeaJdk.$$$reportNull$$$0(8);
        }
        Arrays.sort(forbidden);
        String path = libDirPath + File.separator + LIB_DIR_NAME;
        JarFileSystem jfs = JarFileSystem.getInstance();
        File lib = new File(path);
        if (lib.isDirectory() && (jars = lib.listFiles()) != null) {
            for (File jar : jars) {
                String name = jar.getName();
                if (!jar.isFile() || Arrays.binarySearch(forbidden, name) >= 0 || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                VirtualFile file = jfs.findFileByPath(jar.getPath() + "!/");
                LOG.assertTrue(file != null, (Object)(jar.getPath() + " not found"));
                result.add(file);
            }
        }
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        SdkModificator sdkModificator;
        boolean result;
        Sandbox additionalData;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(9);
        }
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(10);
        }
        if ((additionalData = (Sandbox)sdk.getSdkAdditionalData()) != null) {
            additionalData.cleanupWatchedRoots();
        }
        if ((result = IdeaJdk.setupSdkPaths(sdk, sdkModificator = sdk.getSdkModificator(), sdkModel)) && sdkModificator.getSdkAdditionalData() == null) {
            Sdk[] sdks;
            ArrayList<String> javaSdks = new ArrayList<String>();
            for (Sdk jdk : sdks = sdkModel.getSdks()) {
                if (!IdeaJdk.isValidInternalJdk(sdk, jdk)) continue;
                javaSdks.add(jdk.getName());
            }
            if (javaSdks.isEmpty()) {
                JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(sdk);
                if (requiredVersion != null) {
                    Messages.showErrorDialog((String)DevKitBundle.message("no.java.sdk.for.idea.sdk.found", requiredVersion), (String)"No Java SDK Found");
                } else {
                    Messages.showErrorDialog((String)DevKitBundle.message("no.idea.sdk.version.found", new Object[0]), (String)"No Java SDK Found");
                }
                return false;
            }
            int choice = Messages.showChooseDialog((String)("Select Java SDK to be used for " + DevKitBundle.message("sdk.title", new Object[0])), (String)"Select Internal Java Platform", (String[])ArrayUtil.toStringArray(javaSdks), (String)((String)javaSdks.get(0)), (Icon)Messages.getQuestionIcon());
            if (choice != -1) {
                String name = (String)javaSdks.get(choice);
                Sdk internalJava = (Sdk)ObjectUtils.assertNotNull((Object)sdkModel.findSdk(name));
                IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
            } else {
                result = false;
            }
        }
        sdkModificator.commitChanges();
        return result;
    }

    private static void setInternalJdk(@NotNull Sdk sdk, @NotNull SdkModificator sdkModificator, @NotNull Sdk internalJava) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(11);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(12);
        }
        if (internalJava == null) {
            IdeaJdk.$$$reportNull$$$0(13);
        }
        IdeaJdk.addClasses(sdkModificator, internalJava);
        IdeaJdk.addDocs(sdkModificator, internalJava);
        IdeaJdk.addSources(sdkModificator, internalJava);
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Sandbox(IdeaJdk.getDefaultSandbox(), internalJava, sdk));
        sdkModificator.setVersionString(internalJava.getVersionString());
    }

    static boolean isValidInternalJdk(@NotNull Sdk ideaSdk, @NotNull Sdk sdk) {
        SdkTypeId sdkType;
        if (ideaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(14);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(15);
        }
        if ((sdkType = sdk.getSdkType()) instanceof JavaSdk) {
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
            JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(ideaSdk);
            if (version != null && requiredVersion != null) {
                return version.isAtLeast(requiredVersion);
            }
        }
        return false;
    }

    @Nullable
    private static JavaSdkVersion getRequiredJdkVersion(Sdk ideaSdk) {
        if (IdeaJdk.isFromIDEAProject(ideaSdk.getHomePath())) {
            return JavaSdkVersion.JDK_1_8;
        }
        File apiJar = IdeaJdk.getOpenApiJar(ideaSdk.getHomePath());
        int classFileVersion = apiJar == null ? -1 : IdeaJdk.getIdeaClassFileVersion(apiJar);
        LanguageLevel languageLevel = classFileVersion <= 0 ? null : ClsParsingUtil.getLanguageLevelByVersion((int)classFileVersion);
        return languageLevel != null ? JavaSdkVersion.fromLanguageLevel((LanguageLevel)languageLevel) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIdeaClassFileVersion(File apiJar) {
        try (ZipFile zipFile = new ZipFile(apiJar);){
            ZipEntry entry = zipFile.getEntry(ApplicationStarter.class.getName().replace('.', '/') + ".class");
            if (entry == null) return -1;
            try (DataInputStream stream = new DataInputStream(zipFile.getInputStream(entry));){
                if (stream.skip(6L) != 6L) return -1;
                int n = stream.readUnsignedShort();
                return n;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return -1;
    }

    private static boolean setupSdkPaths(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) {
        String sdkHome = (String)ObjectUtils.notNull((Object)sdk.getHomePath());
        if (IdeaJdk.isFromIDEAProject(sdkHome)) {
            try {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    IdeaJdk.setupSdkPathsFromIDEAProject(sdk, sdkModificator, sdkModel);
                    return null;
                }, "Scanning for Roots", true, null);
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                Messages.showErrorDialog((String)e.toString(), (String)DevKitBundle.message("sdk.title", new Object[0]));
                return false;
            }
        } else {
            VirtualFile[] ideaLib;
            for (VirtualFile aIdeaLib : ideaLib = IdeaJdk.getIdeaLibrary(sdkHome)) {
                sdkModificator.addRoot(aIdeaLib, OrderRootType.CLASSES);
            }
            IdeaJdk.addSources(new File(sdkHome), sdkModificator);
        }
        return true;
    }

    private static void setupSdkPathsFromIDEAProject(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) throws IOException {
        ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.assertNotNull((Object)ProgressManager.getInstance().getProgressIndicator());
        String sdkHome = (String)ObjectUtils.notNull((Object)sdk.getHomePath());
        JpsModel model = JpsSerializationManager.getInstance().loadModel(sdkHome, PathManager.getOptionsPath());
        JpsSdkReference sdkRef = model.getProject().getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        String sdkName = sdkRef == null ? null : sdkRef.getSdkName();
        Sdk internalJava = sdkModel.findSdk(sdkName);
        if (internalJava != null && IdeaJdk.isValidInternalJdk(sdk, internalJava)) {
            IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
        }
        THashSet addedRoots = ContainerUtil.newTroveSet();
        VirtualFileManager vfsManager = VirtualFileManager.getInstance();
        JpsJavaExtensionService javaService = JpsJavaExtensionService.getInstance();
        boolean isUltimate = vfsManager.findFileByUrl(VfsUtilCore.pathToUrl((String)(sdkHome + "/ultimate/ultimate-resources"))) != null;
        THashSet suppressedModules = ContainerUtil.newTroveSet((Object[])new String[]{"jps-plugin-system"});
        THashSet ultimateModules = ContainerUtil.newTroveSet((Object[])new String[]{"platform-ultimate", "ultimate-resources", "ultimate-verifier", "diagram-api", "diagram-impl", "uml-plugin"});
        List modules = JBIterable.from((Iterable)model.getProject().getModules()).filter(arg_0 -> IdeaJdk.lambda$setupSdkPathsFromIDEAProject$1((Set)suppressedModules, isUltimate, (Set)ultimateModules, arg_0)).toList();
        indicator.setIndeterminate(false);
        double delta = 1.0 / (2.0 * Math.max(0.5, (double)modules.size()));
        for (JpsModule o : modules) {
            indicator.setFraction(indicator.getFraction() + delta);
            for (JpsDependencyElement dep : o.getDependenciesList().getDependencies()) {
                VirtualFile root;
                JpsJavaDependencyExtension extension;
                ProgressManager.checkCanceled();
                JpsLibrary library = dep instanceof JpsLibraryDependency ? ((JpsLibraryDependency)dep).getLibrary() : null;
                JpsLibraryType libraryType = library == null ? null : library.getType();
                if (!(libraryType instanceof JpsJavaLibraryType) || (extension = javaService.getDependencyExtension(dep)) == null) continue;
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.COMPILED)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.CLASSES);
                }
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.SOURCES)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.SOURCES);
                }
            }
        }
        for (JpsModule o : modules) {
            VirtualFile outputRoot;
            indicator.setFraction(indicator.getFraction() + delta);
            String outputUrl = javaService.getOutputUrl(o, false);
            VirtualFile virtualFile = outputRoot = outputUrl == null ? null : vfsManager.findFileByUrl(outputUrl);
            if (outputRoot == null) continue;
            sdkModificator.addRoot(outputRoot, OrderRootType.CLASSES);
            for (JpsModuleSourceRoot jps : o.getSourceRoots()) {
                ProgressManager.checkCanceled();
                VirtualFile root = vfsManager.findFileByUrl(jps.getUrl());
                if (root == null || !addedRoots.add(root)) continue;
                sdkModificator.addRoot(root, OrderRootType.SOURCES);
            }
        }
        indicator.setFraction(1.0);
    }

    static String getDefaultSandbox() {
        String defaultSandbox = "";
        try {
            defaultSandbox = new File(PathManager.getSystemPath()).getCanonicalPath() + File.separator + "plugins-sandbox";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultSandbox;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        File src = new File(new File(file, LIB_DIR_NAME), SRC_DIR_NAME);
        if (!src.exists()) {
            return;
        }
        File[] srcs = src.listFiles(pathname -> {
            String path = pathname.getPath();
            if (path.contains("generics")) {
                return false;
            }
            return path.endsWith(".jar") || path.endsWith(".zip");
        });
        for (int i = 0; srcs != null && i < srcs.length; ++i) {
            File jarFile = srcs[i];
            if (!jarFile.exists()) continue;
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    private static void addClasses(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(16);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(17);
        }
        IdeaJdk.addOrderEntries(OrderRootType.CLASSES, javaSdk, sdkModificator);
    }

    private static void addDocs(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(18);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(19);
        }
        if (!IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), javaSdk, sdkModificator) && SystemInfo.isMac) {
            Sdk[] jdks;
            for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), jdk, sdkModificator);
                break;
            }
        }
    }

    private static void addSources(SdkModificator sdkModificator, Sdk javaSdk) {
        if (javaSdk != null && !IdeaJdk.addOrderEntries(OrderRootType.SOURCES, javaSdk, sdkModificator)) {
            if (SystemInfo.isMac) {
                Sdk[] jdks;
                for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                    if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                    IdeaJdk.addOrderEntries(OrderRootType.SOURCES, jdk, sdkModificator);
                    break;
                }
            } else {
                String homePath = javaSdk.getHomePath();
                if (homePath == null) {
                    return;
                }
                File jdkHome = new File(homePath).getParentFile();
                String srcZip = "src.zip";
                File jarFile = new File(jdkHome, "src.zip");
                if (jarFile.exists()) {
                    JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                    String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
                    jarFileSystem.setNoCopyJarForPath(path);
                    sdkModificator.addRoot(jarFileSystem.findFileByPath(path), OrderRootType.SOURCES);
                }
            }
        }
    }

    private static boolean addOrderEntries(@NotNull OrderRootType orderRootType, @NotNull Sdk sdk, @NotNull SdkModificator toModificator) {
        String[] entries;
        if (orderRootType == null) {
            IdeaJdk.$$$reportNull$$$0(20);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(21);
        }
        if (toModificator == null) {
            IdeaJdk.$$$reportNull$$$0(22);
        }
        boolean wasSmthAdded = false;
        for (String entry : entries = sdk.getRootProvider().getUrls(orderRootType)) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(entry);
            if (virtualFile == null) continue;
            toModificator.addRoot(virtualFile, orderRootType);
            wasSmthAdded = true;
        }
        return wasSmthAdded;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(23);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(24);
        }
        return new IdeaJdkConfigurable(sdkModel, sdkModificator);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(25);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        Sdk jdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(26);
        }
        if ((jdk = IdeaJdk.getInternalJavaSdk(sdk)) != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(27);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            IdeaJdk.$$$reportNull$$$0(28);
        }
        if (additional == null) {
            IdeaJdk.$$$reportNull$$$0(29);
        }
        if (additionalData instanceof Sandbox) {
            try {
                ((Sandbox)additionalData).writeExternal(additional);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, Element additional) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(30);
        }
        Sandbox sandbox = new Sandbox(sdk);
        try {
            sandbox.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return sandbox;
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("sdk.title", new Object[0]);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public static Sdk findIdeaJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        if (jdk.getSdkType() instanceof IdeaJdk) {
            return jdk;
        }
        return null;
    }

    public static SdkType getInstance() {
        return SdkType.findInstance(IdeaJdk.class);
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            IdeaJdk.$$$reportNull$$$0(32);
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(33);
        }
        return JavaSdk.getInstance().getDefaultDocumentationUrl(sdk);
    }

    private static /* synthetic */ boolean lambda$setupSdkPathsFromIDEAProject$1(Set suppressedModules, boolean isUltimate, Set ultimateModules, JpsModule o) {
        if (suppressedModules.contains(o.getName())) {
            return false;
        }
        if (o.getName().endsWith("-ide")) {
            return false;
        }
        String contentUrl = (String)ContainerUtil.getFirstItem((List)o.getContentRootsList().getUrls());
        if (contentUrl == null) {
            return true;
        }
        return !isUltimate || contentUrl.contains("/community/") || ultimateModules.contains(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbidden";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalJava";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaSdk";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModificator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendIdeaLibrary";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setInternalJdk";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidInternalJdk";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDocs";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addOrderEntries";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

