/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataGroupVirtualFile;

public class TestDataGroupFileEditor
extends UserDataHolderBase
implements FileEditor {
    private WeakReference<JComponent> myComponent;
    private final TestDataGroupVirtualFile myFile;
    private final FileEditor myBeforeEditor;
    private final FileEditor myAfterEditor;

    public TestDataGroupFileEditor(Project project, TestDataGroupVirtualFile file) {
        this.myFile = file;
        this.myBeforeEditor = TextEditorProvider.getInstance().createEditor(project, file.getBeforeFile());
        this.myAfterEditor = TextEditorProvider.getInstance().createEditor(project, file.getAfterFile());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent result = (JComponent)SoftReference.dereference(this.myComponent);
        if (result == null) {
            result = this.createComponent();
            this.myComponent = new WeakReference<JComponent>(result);
        }
        JComponent jComponent = result;
        if (jComponent == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    private JComponent createComponent() {
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getBeforeFile().getName(), this.myBeforeEditor));
        splitter.setSecondComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getAfterFile().getName(), this.myAfterEditor));
        return splitter;
    }

    private static JComponent wrapWithTitle(String name, FileEditor beforeEditor) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(name);
        label.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)2, (int)0));
        label.setFont(label.getFont().deriveFont(1));
        panel.add("North", label);
        panel.add("Center", beforeEditor.getComponent());
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(2);
        }
    }

    public boolean isModified() {
        return this.myBeforeEditor.isModified() || this.myAfterEditor.isModified();
    }

    public boolean isValid() {
        return this.myBeforeEditor.isValid() && this.myAfterEditor.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(3);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(4);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        TextEditorProvider.getInstance().disposeEditor(this.myBeforeEditor);
        TextEditorProvider.getInstance().disposeEditor(this.myAfterEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

