/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.TestSourceFolder")
public class TestDataGroupVirtualFile
extends VirtualFile {
    private final VirtualFile myBeforeFile;
    private final VirtualFile myAfterFile;

    public TestDataGroupVirtualFile(@NotNull VirtualFile beforeFile, @NotNull VirtualFile afterFile) {
        if (beforeFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(0);
        }
        if (afterFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(1);
        }
        this.myBeforeFile = beforeFile;
        this.myAfterFile = afterFile;
    }

    @NotNull
    public String getName() {
        String prefix = StringUtil.commonPrefix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
        if (prefix.isEmpty()) {
            String string = StringUtil.commonSuffix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
            if (string == null) {
                TestDataGroupVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = prefix + "." + this.myBeforeFile.getExtension();
        if (string == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(3);
        }
        return string;
    }

    public VirtualFile getBeforeFile() {
        return this.myBeforeFile;
    }

    public VirtualFile getAfterFile() {
        return this.myAfterFile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(4);
        }
        return localFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myBeforeFile.getPath();
        if (string == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isWritable() {
        return this.myBeforeFile.isWritable();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.myBeforeFile.isValid() && this.myAfterFile.isValid();
    }

    public VirtualFile getParent() {
        return this.myBeforeFile.getParent();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return this.myBeforeFile.getTimeStamp();
    }

    public long getLength() {
        return this.myBeforeFile.getLength();
    }

    public long getModificationStamp() {
        return this.myBeforeFile.getModificationStamp();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myBeforeFile.getFileType();
        if (fileType == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestDataGroupVirtualFile file = (TestDataGroupVirtualFile)((Object)o);
        if (!this.myAfterFile.equals(file.myAfterFile)) {
            return false;
        }
        return this.myBeforeFile.equals(file.myBeforeFile);
    }

    public int hashCode() {
        int result = this.myBeforeFile.hashCode();
        result = 31 * result + this.myAfterFile.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

