/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public class ExtensionLocator {
    private final PsiClass myPsiClass;

    public ExtensionLocator(PsiClass aClass) {
        this.myPsiClass = aClass;
    }

    @NotNull
    public List<ExtensionCandidate> findCandidates() {
        String name = this.myPsiClass.getQualifiedName();
        if (name == null) {
            List<ExtensionCandidate> list = Collections.emptyList();
            if (list == null) {
                ExtensionLocator.$$$reportNull$$$0(0);
            }
            return list;
        }
        SmartList result = new SmartList();
        ExtensionLocator.processExtensionDeclarations(this.myPsiClass, new ReferenceProcessor(name, arg_0 -> ExtensionLocator.lambda$findCandidates$0((List)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            ExtensionLocator.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    public static boolean isRegisteredExtension(@NotNull PsiClass psiClass) {
        String name;
        if (psiClass == null) {
            ExtensionLocator.$$$reportNull$$$0(2);
        }
        if ((name = psiClass.getQualifiedName()) == null) {
            return false;
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        ExtensionLocator.processExtensionDeclarations(psiClass, new ReferenceProcessor(name, (Processor)processor));
        return processor.isFound();
    }

    private static void processExtensionDeclarations(PsiClass psiClass, PsiNonJavaFileReferenceProcessor referenceProcessor) {
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return;
        }
        Project project = psiClass.getProject();
        GlobalSearchScope scope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        PsiSearchHelper.SERVICE.getInstance((Project)project).processUsagesInNonJavaFiles(name, referenceProcessor, scope);
    }

    private static /* synthetic */ boolean lambda$findCandidates$0(List result, XmlTag tag) {
        result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag)));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/util/ExtensionLocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRegisteredExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceProcessor
    implements PsiNonJavaFileReferenceProcessor {
        private final String myExtensionClassName;
        private final Processor<XmlTag> myExtensionTagHandler;

        private ReferenceProcessor(String name, Processor<XmlTag> extensionTagHandler) {
            this.myExtensionClassName = name;
            this.myExtensionTagHandler = extensionTagHandler;
        }

        public boolean process(PsiFile file, int startOffset, int endOffset) {
            String tokenText;
            PsiElement element = file.findElementAt(startOffset);
            String string = tokenText = element instanceof XmlToken ? element.getText() : null;
            if (!StringUtil.equals((CharSequence)this.myExtensionClassName, (CharSequence)tokenText)) {
                return true;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null) {
                return true;
            }
            DomElement dom = DomUtil.getDomElement((PsiElement)tag);
            if (dom instanceof Extension && ((Extension)dom).getExtensionPoint() != null) {
                return this.myExtensionTagHandler.process((Object)tag);
            }
            return true;
        }
    }
}

