/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.Version;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFamilyId {
    private static final ConcurrentMap<String, DatabaseFamilyId> ourFamilies = ContainerUtil.newConcurrentMap();
    public static final DatabaseFamilyId UNKNOWN = DatabaseFamilyId.create("UNKNOWN");
    public static final DatabaseFamilyId ORACLE = DatabaseFamilyId.create("ORACLE");
    public static final DatabaseFamilyId MYSQL = DatabaseFamilyId.create("MYSQL");
    public static final DatabaseFamilyId POSTGRES = DatabaseFamilyId.create("POSTGRES");
    public static final DatabaseFamilyId REDSHIFT = DatabaseFamilyId.create("REDSHIFT");
    public static final DatabaseFamilyId MSSQL = DatabaseFamilyId.create("MSSQL");
    public static final DatabaseFamilyId SYBASE = DatabaseFamilyId.create("SYBASE");
    public static final DatabaseFamilyId DB2 = DatabaseFamilyId.create("DB2");
    public static final DatabaseFamilyId SQLITE = DatabaseFamilyId.create("SQLITE");
    public static final DatabaseFamilyId HSQLDB = DatabaseFamilyId.create("HSQLDB");
    public static final DatabaseFamilyId H2 = DatabaseFamilyId.create("H2");
    public static final DatabaseFamilyId DERBY = DatabaseFamilyId.create("DERBY");
    public static final DatabaseFamilyId EXASOL = DatabaseFamilyId.create("EXASOL");
    public static final DatabaseFamilyId MARIADB = DatabaseFamilyId.create("MARIADB");
    public static final DatabaseFamilyId VERTICA = DatabaseFamilyId.create("VERTICA");
    public static final DatabaseFamilyId PRESTO = DatabaseFamilyId.create("PRESTO");
    public static final DatabaseFamilyId INFORMIX = DatabaseFamilyId.create("INFORMIX");
    public static final DatabaseFamilyId IMPALA = DatabaseFamilyId.create("IMPALA");
    public static final DatabaseFamilyId NETEZZA = DatabaseFamilyId.create("NETEZZA");
    public static final DatabaseFamilyId PHOENIX = DatabaseFamilyId.create("PHOENIX");
    public static final DatabaseFamilyId HIVE = DatabaseFamilyId.create("HIVE");
    public static final DatabaseFamilyId SNOWFLAKE = DatabaseFamilyId.create("SNOWFLAKE");
    public static final DatabaseFamilyId INGRES = DatabaseFamilyId.create("INGRES");
    public static final DatabaseFamilyId TERADATA = DatabaseFamilyId.create("TERADATA");
    public static final DatabaseFamilyId OPENEDGE = DatabaseFamilyId.create("OPENEDGE");
    public static final DatabaseFamilyId TIBERO = DatabaseFamilyId.create("TIBERO");
    public static final DatabaseFamilyId FILEMAKER = DatabaseFamilyId.create("FILEMAKER");
    private final String myName;

    @NotNull
    public static DatabaseFamilyId create(@NotNull String name) {
        DatabaseFamilyId existing;
        if (name == null) {
            DatabaseFamilyId.$$$reportNull$$$0(0);
        }
        if ((existing = (DatabaseFamilyId)ourFamilies.get(name)) != null) {
            DatabaseFamilyId databaseFamilyId = existing;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(1);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = (DatabaseFamilyId)ConcurrencyUtil.cacheOrGet(ourFamilies, (Object)name, (Object)new DatabaseFamilyId(name));
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(2);
        }
        return databaseFamilyId;
    }

    private DatabaseFamilyId(@NotNull String name) {
        if (name == null) {
            DatabaseFamilyId.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DatabaseFamilyId.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL || this == MARIADB;
    }

    public boolean isPostgres() {
        return this == POSTGRES || this == REDSHIFT;
    }

    public boolean isRedshift() {
        return this == REDSHIFT;
    }

    public boolean isVertica() {
        return this == VERTICA;
    }

    public boolean isMicrosoft() {
        return this == MSSQL;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQLDB;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    public boolean isExasol() {
        return this == EXASOL;
    }

    @NotNull
    public static DatabaseFamilyId forDataSource(@NotNull DatabaseSystem o) {
        DatabaseFamilyId result;
        if (o == null) {
            DatabaseFamilyId.$$$reportNull$$$0(5);
        }
        if ((result = DatabaseFamilyId.fromString(o.getDatabaseProductName())) == UNKNOWN && o instanceof RawConnectionConfig) {
            result = DatabaseFamilyId.forConnection((RawConnectionConfig)((Object)o));
        }
        if (result == POSTGRES) {
            Version version;
            String str = o.getDatabaseProductVersion();
            Version version2 = version = str != null && str.contains("8") ? Version.parseVersion((String)str) : null;
            if (version != null && version.major == 8 && version.bugfix == 2) {
                result = REDSHIFT;
            }
        }
        DatabaseFamilyId databaseFamilyId = result;
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(6);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(7);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getUrl());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(8);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.fromString(o.getDriverClass());
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(9);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId fromString(@Nullable String text) {
        if (text == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(10);
            }
            return databaseFamilyId;
        }
        String pattern = "(?i).*(?:%s).*";
        for (DatabaseFamilyId family : ourFamilies.values()) {
            if (!text.matches(String.format(pattern, family.getName()))) continue;
            DatabaseFamilyId databaseFamilyId = family;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(11);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "hsql"))) {
            DatabaseFamilyId databaseFamilyId = HSQLDB;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(12);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "microsoft|sqlserver"))) {
            DatabaseFamilyId databaseFamilyId = MSSQL;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(13);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "adaptive server")) || text.startsWith("ase")) {
            DatabaseFamilyId databaseFamilyId = SYBASE;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(14);
            }
            return databaseFamilyId;
        }
        if (text.startsWith("ids")) {
            DatabaseFamilyId databaseFamilyId = INFORMIX;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(15);
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "exa"))) {
            DatabaseFamilyId databaseFamilyId = EXASOL;
            if (databaseFamilyId == null) {
                DatabaseFamilyId.$$$reportNull$$$0(16);
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = UNKNOWN;
        if (databaseFamilyId == null) {
            DatabaseFamilyId.$$$reportNull$$$0(17);
        }
        return databaseFamilyId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/DatabaseFamilyId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/DatabaseFamilyId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataSource";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

