/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleLocalModel<T extends PsiElement>
extends AbstractSimpleSpringModel
implements LocalModel<T> {
    private static final Key<CachedValue<Map<String, LazyModelDependenciesGraph>>> MODELS_GRAPH_KEY = Key.create((String)"MODELS_GRAPH_KEY");
    private final NotNullLazyValue<CommonSpringModel> myCustomDiscoveredBeansModel = new VolatileNotNullLazyValue<CommonSpringModel>(){

        @NotNull
        protected CommonSpringModel compute() {
            BeansSpringModel beansSpringModel = new BeansSpringModel(AbstractSimpleLocalModel.this.getModule(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    Collection collection = AbstractSimpleLocalModel.this.computeCustomBeans();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1$1", "compute"));
                }
            });
            if (beansSpringModel == null) {
                1.$$$reportNull$$$0(0);
            }
            return beansSpringModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$1", "compute"));
        }
    };

    protected static void addNotNullModel(@NotNull Set<Pair<LocalModel, LocalModelDependency>> models, @Nullable LocalModel model, @NotNull LocalModelDependency dependency) {
        if (models == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(0);
        }
        if (dependency == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(1);
        }
        if (model != null) {
            models.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)model, (Object)dependency));
        }
    }

    private Collection<? extends SpringBeanPointer> computeCustomBeans() {
        LinkedHashSet customSpringComponents = ContainerUtil.newLinkedHashSet();
        for (CustomLocalComponentsDiscoverer discoverer : (CustomLocalComponentsDiscoverer[])Extensions.getExtensions(CustomLocalComponentsDiscoverer.EP_NAME)) {
            customSpringComponents.addAll(discoverer.getCustomComponents(this));
        }
        return BeanService.getInstance().mapSpringBeans(customSpringComponents);
    }

    protected CommonSpringModel getCustomDiscoveredBeansModel() {
        return (CommonSpringModel)this.myCustomDiscoveredBeansModel.getValue();
    }

    @Override
    @NotNull
    public Set<LocalModel> getRelatedLocalModels() {
        Module module = this.getModule();
        if (module == null || module.isDisposed()) {
            Set<LocalModel> set = Collections.emptySet();
            if (set == null) {
                AbstractSimpleLocalModel.$$$reportNull$$$0(2);
            }
            return set;
        }
        LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph(module, this.getActiveProfiles());
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        AbstractSimpleLocalModel.visitRelated(this, graph, visited);
        visited.remove(this);
        LinkedHashSet linkedHashSet = visited;
        if (linkedHashSet == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    private static void visitRelated(@NotNull LocalModel model, @NotNull Graph<LocalModel> graph, @NotNull Set<LocalModel> visited) {
        if (model == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(4);
        }
        if (graph == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(5);
        }
        if (visited == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(6);
        }
        visited.add(model);
        Iterator out = graph.getOut((Object)model);
        while (out.hasNext()) {
            LocalModel outModel = (LocalModel)out.next();
            if (visited.contains(outModel)) continue;
            AbstractSimpleLocalModel.visitRelated(outModel, graph, visited);
        }
    }

    private static Object[] getDependencies(@NotNull Project project) {
        if (project == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(7);
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance(project);
        set.add(springModificationTrackersManager.getProfilesModificationTracker());
        set.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        set.add(springModificationTrackersManager.getCustomBeanParserModificationTracker());
        set.add(ProjectRootManager.getInstance((Project)project));
        return set.toArray();
    }

    @NotNull
    public static LazyModelDependenciesGraph getOrCreateLocalModelDependenciesGraph(@NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (module == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(8);
        }
        if (activeProfiles == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(9);
        }
        String key = SpringProfileUtils.profilesAsString(activeProfiles);
        Map graphsMap = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, MODELS_GRAPH_KEY, AbstractSimpleLocalModel.createGraphProvider(module, activeProfiles), false);
        LazyModelDependenciesGraph lazyModelDependenciesGraph = (LazyModelDependenciesGraph)graphsMap.get(key);
        if (lazyModelDependenciesGraph == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(10);
        }
        return lazyModelDependenciesGraph;
    }

    @NotNull
    private static CachedValueProvider<Map<String, LazyModelDependenciesGraph>> createGraphProvider(Module module, Set<String> activeProfiles) {
        CachedValueProvider cachedValueProvider = () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> new LazyModelDependenciesGraph(module, activeProfiles));
            return CachedValueProvider.Result.create((Object)map, (Object[])AbstractSimpleLocalModel.getDependencies(module.getProject()));
        };
        if (cachedValueProvider == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(11);
        }
        return cachedValueProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConfig() + "]";
    }

    @NotNull
    protected Object[] getOutsideModelDependencies(@NotNull LocalModel model) {
        if (model == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(12);
        }
        Project project = model.getConfig().getProject();
        ArrayList<Object> dependencies = new ArrayList<Object>(5);
        dependencies.add(model.getConfig());
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance(project);
        dependencies.add(springModificationTrackersManager.getProfilesModificationTracker());
        dependencies.add(springModificationTrackersManager.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        dependencies.add(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(13);
        }
        return objectArray;
    }

    @NotNull
    protected PsiElement[] getConfigs(@NotNull Set<LocalModel> localModels) {
        if (localModels == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(14);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array(localModels, PsiElement.class, LocalModel::getConfig);
        if (psiElementArray == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(15);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedLocalModels";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLocalModelDependenciesGraph";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createGraphProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutsideModelDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullModel";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRelated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalModelDependenciesGraph";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOutsideModelDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

