/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FieldRetrievingFactoryBeanConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    protected final boolean mySoft;

    protected FieldRetrievingFactoryBeanConverter() {
        this(true);
    }

    protected FieldRetrievingFactoryBeanConverter(boolean soft) {
        this.mySoft = soft;
    }

    protected boolean requireFieldReference() {
        return false;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(genericDomValue, element);
        if (psiReferenceArray == null) {
            FieldRetrievingFactoryBeanConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element) {
        PsiReference reference;
        PsiElement psiElement;
        String stringValue = genericDomValue.getStringValue();
        if (stringValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> collectedReferences = new ArrayList<PsiReference>();
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        provider.setSoft(this.mySoft);
        provider.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.TRUE);
        PsiReference[] javaClassReferences = provider.getReferencesByElement(element);
        PsiClass psiClass = null;
        PsiReference[] psiReferenceArray = javaClassReferences;
        int n = psiReferenceArray.length;
        for (int i = 0; i < n && (psiElement = (reference = psiReferenceArray[i]).resolve()) != null; ++i) {
            collectedReferences.add(reference);
            if (!(psiElement instanceof PsiClass)) continue;
            psiClass = (PsiClass)psiElement;
        }
        if (psiClass == null || !this.requireFieldReference() && psiClass.getQualifiedName() != null && stringValue.endsWith(psiClass.getQualifiedName())) {
            return javaClassReferences;
        }
        collectedReferences.add(this.createFieldReference(psiClass, element, stringValue, genericDomValue));
        return collectedReferences.toArray(new PsiReference[collectedReferences.size()]);
    }

    private PsiReference createFieldReference(PsiClass psiClass, PsiElement element, String stringValue, GenericDomValue<String> genericDomValue) {
        String className = psiClass.getName();
        assert (className != null);
        int fieldNameIdx = stringValue.lastIndexOf(className) + className.length();
        String fieldName = stringValue.substring(Math.min(stringValue.length(), fieldNameIdx + 1)).trim();
        TextRange textRange = fieldName.isEmpty() ? TextRange.from((int)(element.getText().indexOf(className) + className.length() + 1), (int)0) : TextRange.from((int)Math.max(0, element.getText().lastIndexOf(fieldName)), (int)fieldName.length());
        return new FieldReference(element, textRange, fieldName, psiClass, genericDomValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter", "createReferences"));
    }

    public static class FieldReferenceRequired
    extends FieldRetrievingFactoryBeanConverter {
        @Override
        protected boolean requireFieldReference() {
            return true;
        }
    }

    protected class FieldReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myFieldName;
        private final PsiClass myPsiClass;
        private final GenericDomValue<String> myGenericDomValue;

        protected FieldReference(PsiElement element, TextRange textRange, String fieldName, PsiClass psiClass, GenericDomValue<String> genericDomValue) {
            super(element, textRange, FieldRetrievingFactoryBeanConverter.this.mySoft);
            this.myFieldName = fieldName;
            this.myPsiClass = psiClass;
            this.myGenericDomValue = genericDomValue;
        }

        public PsiElement resolve() {
            if (this.myFieldName.length() != 0) {
                PsiField[] psiFields;
                for (PsiField psiField : psiFields = this.myPsiClass.getAllFields()) {
                    if (!psiField.hasModifierProperty("public") || !psiField.hasModifierProperty("static") || !this.myFieldName.equals(psiField.getName())) continue;
                    return psiField;
                }
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            PsiField field;
            PsiClass containingClass;
            if (element == null) {
                FieldReference.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
                this.myGenericDomValue.setStringValue(containingClass.getQualifiedName() + "." + field.getName());
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            PsiField[] psiFields;
            ArrayList<LookupElementBuilder> staticFields = new ArrayList<LookupElementBuilder>();
            for (PsiField psiField : psiFields = this.myPsiClass.getFields()) {
                if (!psiField.hasModifierProperty("public") || !psiField.hasModifierProperty("static") || psiField.getName() == null) continue;
                staticFields.add(JavaLookupElementBuilder.forField((PsiField)psiField, (String)psiField.getName(), (PsiClass)this.myPsiClass).withTypeText(psiField.getType().getPresentableText()));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(staticFields);
            if (objectArray == null) {
                FieldReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String fieldName = this.getValue();
            if (fieldName.isEmpty() || fieldName.equals(".")) {
                if ("Field name expected" == null) {
                    FieldReference.$$$reportNull$$$0(2);
                }
                return "Field name expected";
            }
            String string = "Cannot resolve field '" + fieldName + "'";
            if (string == null) {
                FieldReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/values/converters/FieldRetrievingFactoryBeanConverter$FieldReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

