/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorArgumentValues {
    private static final Comparator<ConstructorArg> ARG_COMPARATOR = (o1, o2) -> Comparing.compare((boolean)DomUtil.hasXml(o2.getType()), (boolean)DomUtil.hasXml(o1.getType()));
    private Map<String, ConstructorArgDefinition> namedArgs;
    private Map<Integer, ConstructorArgDefinition> indexedArgs;
    private List<ConstructorArg> genericArgs;

    public int init(@NotNull SpringBean bean) {
        if (bean == null) {
            ConstructorArgumentValues.$$$reportNull$$$0(0);
        }
        Set<ConstructorArg> args = bean.getAllConstructorArgs();
        this.indexedArgs = new HashMap<Integer, ConstructorArgDefinition>(args.size());
        this.genericArgs = new ArrayList<ConstructorArg>(args.size());
        this.namedArgs = new HashMap<String, ConstructorArgDefinition>();
        int minNrOfArgs = args.size();
        for (CNamespaceDomElement definition : bean.getCNamespaceConstructorArgDefinitions()) {
            String name = definition.getAttributeName();
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            if (!definition.isIndexAttribute()) {
                this.namedArgs.put(name, definition);
                continue;
            }
            Integer index = definition.getIndex();
            if (index == null) continue;
            this.indexedArgs.put(index, definition);
        }
        for (ConstructorArg arg : args) {
            Integer index = (Integer)arg.getIndex().getValue();
            if (index != null) {
                this.indexedArgs.put(index, arg);
                minNrOfArgs = Math.max(minNrOfArgs, index);
                continue;
            }
            if (DomUtil.hasXml(arg.getNameAttr())) {
                String name = arg.getNameAttr().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                this.namedArgs.put(name, arg);
                continue;
            }
            this.genericArgs.add(arg);
        }
        Collections.sort(this.genericArgs, ARG_COMPARATOR);
        return minNrOfArgs;
    }

    @Nullable
    public ConstructorArgDefinition resolve(int index, PsiParameter parameter, @Nullable Set<ConstructorArgDefinition> usedArgs) {
        ConstructorArgDefinition arg;
        PsiType paramType = parameter.getType();
        if (!this.namedArgs.isEmpty() && (arg = this.resolveNamed(parameter.getName(), paramType)) != null) {
            return arg;
        }
        arg = this.resolveIndexed(index, paramType);
        if (arg != null) {
            return arg;
        }
        return this.resolveGeneric(paramType, usedArgs);
    }

    @Nullable
    public ConstructorArg resolveGeneric(@Nullable PsiType requiredType, @Nullable Set<ConstructorArgDefinition> usedArgs) {
        for (ConstructorArg arg : this.genericArgs) {
            if (usedArgs != null && usedArgs.contains(arg)) continue;
            PsiType type = (PsiType)arg.getType().getValue();
            if (!(requiredType == null ? type == null : (type != null ? requiredType.isAssignableFrom(type) : usedArgs == null || arg.isAssignable(requiredType)))) continue;
            return arg;
        }
        return null;
    }

    @Nullable
    private ConstructorArgDefinition resolveIndexed(int index, PsiType paramType) {
        ConstructorArgDefinition arg = this.indexedArgs.get(index);
        if (!(arg instanceof ConstructorArg)) {
            return arg;
        }
        PsiType type = (PsiType)((ConstructorArg)arg).getType().getValue();
        if (type == null || type.isAssignableFrom(paramType)) {
            return arg;
        }
        return null;
    }

    @Nullable
    private ConstructorArgDefinition resolveNamed(String name, PsiType paramType) {
        ConstructorArgDefinition arg = this.namedArgs.get(name);
        if (arg == null) {
            return null;
        }
        if (!(arg instanceof ConstructorArg)) {
            return arg;
        }
        PsiType type = (PsiType)((ConstructorArg)arg).getType().getValue();
        if (type == null || type.isAssignableFrom(paramType)) {
            return arg;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/xml/beans/ConstructorArgumentValues", "init"));
    }
}

