/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.inspections.jam.SpringIntegrationJamModelInspectionBase;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamAggregator;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamFilter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamGateway;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPublisher;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamRouter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamServiceActivator;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamSplitter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamTransformer;
import com.intellij.spring.model.SpringBeanPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedMessageChannelInspection
extends SpringIntegrationJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(0);
        }
        JamService jamService = JamService.getJamService((Project)aClass.getProject());
        for (PsiMethod psiMethod : aClass.getMethods()) {
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getAggregator(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getFilter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getGateway(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getPublisher(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getRouter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getServiceActivator(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getSplitter(jamService, psiMethod), holder);
            UnresolvedMessageChannelInspection.checkMethodEndpoint(UnresolvedMessageChannelInspection.getTransformer(jamService, psiMethod), holder);
        }
    }

    private static void checkMethodEndpoint(@Nullable SpringIntegrationJamMethodEndpoint methodEndpoint, ProblemsHolder holder) {
        if (methodEndpoint == null) {
            return;
        }
        for (JamStringAttributeElement<SpringBeanPointer> attributeElement : methodEndpoint.getChannelAttributes()) {
            PsiLiteral psiElement = attributeElement.getPsiLiteral();
            if (psiElement == null) continue;
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)attributeElement.getValue();
            if (springBeanPointer == null) {
                holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.cannot.find.channel", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            PsiClass beanClass = springBeanPointer.getBeanClass();
            if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.integration.MessageChannel") || InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.messaging.MessageChannel")) continue;
            holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.bean.must.be.message.channel", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static SpringIntegrationJamSplitter getSplitter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(1);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(2);
        }
        return (SpringIntegrationJamSplitter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamSplitter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamRouter getRouter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(3);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(4);
        }
        return (SpringIntegrationJamRouter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamRouter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamServiceActivator getServiceActivator(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(5);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(6);
        }
        return (SpringIntegrationJamServiceActivator)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamServiceActivator.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamAggregator getAggregator(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(7);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(8);
        }
        return (SpringIntegrationJamAggregator)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamAggregator.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamFilter getFilter(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(9);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(10);
        }
        return (SpringIntegrationJamFilter)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamFilter.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamGateway getGateway(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(12);
        }
        return (SpringIntegrationJamGateway)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamGateway.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamPublisher getPublisher(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(13);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(14);
        }
        return (SpringIntegrationJamPublisher)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamPublisher.METHOD_META});
    }

    @Nullable
    private static SpringIntegrationJamTransformer getTransformer(@NotNull JamService jamService, @NotNull PsiMethod psiMethod) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(15);
        }
        if (psiMethod == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(16);
        }
        return (SpringIntegrationJamTransformer)jamService.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{SpringIntegrationJamTransformer.METHOD_META});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamService";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSplitter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRouter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getServiceActivator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getAggregator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getGateway";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getPublisher";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransformer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

