/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIntegrationUtil {
    private SpringIntegrationUtil() {
    }

    @NotNull
    public static List<SpringBeanPointer> getMessageChannels(@NotNull Module module) {
        PsiClass messageChannel;
        if (module == null) {
            SpringIntegrationUtil.$$$reportNull$$$0(0);
        }
        if ((messageChannel = SpringIntegrationUtil.isSpringIntegration4Used(module) ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.messaging.MessageChannel") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.MessageChannel")) == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringIntegrationUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)messageChannel).withInheritors();
        SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        List list = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (list == null) {
            SpringIntegrationUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static boolean isSpringIntegration4Used(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.IntegrationMessageHeaderAccessor") != null;
    }

    public static boolean isSpringIntegrationUsed(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.channel.DirectChannel") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/util/SpringIntegrationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/util/SpringIntegrationUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageChannels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessageChannels";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

