/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import icons.CdiCoreIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionsClassAnnotator
extends RelatedItemLineMarkerProvider {
    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !CdiCommonUtils.isCdiInstalled(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement parent;
        if (psiElement == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof PsiIdentifier && (parent = psiElement.getParent()) instanceof PsiClass) {
            PsiFile containingFile = parent.getContainingFile();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parent);
            if (module != null && CdiCommonUtils.isCdiInstalled(module)) {
                PsiClass psiClass = (PsiClass)parent;
                if (CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, module)) {
                    Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
                    MultiMap methodInjections = new MultiMap();
                    for (InjectionPointDescriptor ip : injectionPoints) {
                        PsiModifierListOwner owner = ip.getOwner();
                        if (!containingFile.equals(owner.getContainingFile())) continue;
                        if (owner instanceof PsiParameter) {
                            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class);
                            if (psiMethod != null) {
                                methodInjections.putValue((Object)psiMethod, (Object)ip);
                                continue;
                            }
                            CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, ip);
                            continue;
                        }
                        CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, ip);
                    }
                    for (Map.Entry entry : methodInjections.entrySet()) {
                        PsiMethod psiMethod = (PsiMethod)entry.getKey();
                        Collection descriptors = (Collection)entry.getValue();
                        if (descriptors.size() == 1) {
                            CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, (InjectionPointDescriptor)descriptors.iterator().next());
                            continue;
                        }
                        CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, (List<InjectionPointDescriptor>)new SmartList(descriptors), psiMethod);
                    }
                }
                if (CdiInjectionUtils.canBeInjected(psiClass, module)) {
                    PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(psiClass);
                    CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiMember)psiClass, (PsiType)psiClassType);
                    for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods((PsiClass)parent, false)) {
                        CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiMember)psiMethod, psiMethod.getReturnType());
                    }
                    for (PsiField psiField : CdiCommonUtils.getProducerFields((PsiClass)parent, false)) {
                        CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiMember)psiField, psiField.getType());
                    }
                }
            }
        }
    }

    private static void addOutjectedGutter(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @Nullable PsiMember psiMember, @Nullable PsiType type) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(5);
        }
        if (psiMember == null || type == null) {
            return;
        }
        Set<InjectionPointDescriptor> outjectedPoints = CdiInjectionUtils.getInjectionPoints(type, CdiInjectionUtils.getInjectionPoints(module));
        if (outjectedPoints.size() > 0) {
            HashSet bindedOutjectedPoints = new HashSet();
            PsiAnnotation[] bindingAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)psiMember);
            for (InjectionPointDescriptor point : outjectedPoints) {
                if (!CdiManager.hasAnnotated(point.getOwner(), bindingAnnotations)) continue;
                bindedOutjectedPoints.add(point);
            }
            CdiInjectionsClassAnnotator.addOutjectedGutterIcon(result, (Set<InjectionPointDescriptor>)bindedOutjectedPoints, psiMember);
        }
    }

    private static void addInjectedGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull InjectionPointDescriptor ip) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(6);
        }
        if (ip == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(7);
        }
        CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, CdiInjectionUtils.getInjectedBeans(ip), ip.getOwner(), ip.getType());
    }

    private static void addInjectedGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, Set<CdiBeanDescriptor> beanDescriptors, PsiModifierListOwner owner, PsiType type) {
        if (beanDescriptors != null && beanDescriptors.size() > 0) {
            CdiInjectionsClassAnnotator.addInjectedBeanGutterIcon(result, owner, type, CdiInjectionsClassAnnotator.getTargets(beanDescriptors));
        }
    }

    @NotNull
    private static NotNullLazyValue<Collection<? extends PsiElement>> getTargets(final Set<CdiBeanDescriptor> beanDescriptors) {
        NotNullLazyValue<Collection<? extends PsiElement>> notNullLazyValue = new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<PsiMember> compute() {
                List list = ContainerUtil.mapNotNull((Collection)beanDescriptors, cdiBeanDescriptor -> {
                    if (cdiBeanDescriptor instanceof AbstractCdiBeanDescriptor) {
                        return ((AbstractCdiBeanDescriptor)cdiBeanDescriptor).getAnnotatedItem();
                    }
                    return null;
                });
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator$1", "compute"));
            }
        };
        if (notNullLazyValue == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(8);
        }
        return notNullLazyValue;
    }

    private static void addInjectedGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull List<InjectionPointDescriptor> injectionPointDescriptors, @NotNull PsiMethod psiMethod) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(9);
        }
        if (injectionPointDescriptors == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(10);
        }
        if (psiMethod == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(11);
        }
        LinkedHashSet injectedBeans = ContainerUtil.newLinkedHashSet();
        for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
            for (InjectionPointDescriptor ip : injectionPointDescriptors) {
                if (!psiParameter.equals(ip.getOwner())) continue;
                injectedBeans.addAll(CdiInjectionUtils.getInjectedBeans(ip));
            }
        }
        if (injectedBeans.size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.CdiBean).setTargets(CdiInjectionsClassAnnotator.getTargets(injectedBeans)).setPopupTitle(CdiBundle.message("gutter.choose.bean", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.method.injections", new Object[0]));
            PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)(nameIdentifier == null ? psiMethod : nameIdentifier)));
        }
    }

    private static void addOutjectedGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, Set<InjectionPointDescriptor> ips, PsiMember member) {
        List members = ContainerUtil.map(ips, InjectionPointDescriptor::getOwner);
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Inject).setTargets((Collection)members).setPopupTitle(CdiBundle.message("gutter.choose.injected.point", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.injection.point", new Object[0]));
        PsiMember element = member instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : member;
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)(element == null ? member : element)));
    }

    private static void addInjectedBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiModifierListOwner psiIdentifier, PsiType type, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.CdiBean).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.bean", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to", CdiInjectionsClassAnnotator.getBeanDescription(psiIdentifier, type)));
        PsiElement identifier = CdiInjectionsClassAnnotator.getIdentifingElement(psiIdentifier);
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
        }
    }

    private static PsiElement getIdentifingElement(@NotNull PsiModifierListOwner psiIdentifier) {
        PsiAnnotation injectAnno;
        PsiModifierList modifierList;
        if (psiIdentifier == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(12);
        }
        if ((modifierList = psiIdentifier.getModifierList()) != null && (injectAnno = modifierList.findAnnotation("javax.inject.Inject")) != null) {
            return CdiInjectionsClassAnnotator.getIdentifier(injectAnno);
        }
        if (psiIdentifier instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)psiIdentifier).getNameIdentifier();
        }
        return null;
    }

    public static PsiElement getIdentifier(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement identifier;
        if (annotation == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(13);
        }
        return (identifier = annotation.getNameReferenceElement()) == null ? null : identifier.getReferenceNameElement();
    }

    private static String getBeanDescription(@NotNull PsiModifierListOwner owner, PsiType type) {
        if (owner == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(14);
        }
        Collection<PsiClass> psiClasses = CdiCommonUtils.getQualifierClasses(owner);
        String[] names = (String[])ContainerUtil.map2Array(psiClasses, String.class, psiClass -> "@" + psiClass.getName());
        return StringUtil.join((String[])names, (String)" ") + " " + type.getPresentableText();
    }

    @Nullable
    public String getName() {
        return "Injection points";
    }

    public String getId() {
        return "CdiInjectionsClassAnnotator";
    }

    @Nullable
    public Icon getIcon() {
        return CdiCoreIcons.CdiBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointDescriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiIdentifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOutjectedGutter";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedGutterIcon";
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifingElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

