/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.web.facet.WebFacet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JavaeeConvertingContext {
    private final Map<String, FacetTypeId<? extends JavaeeFacet>> myModuleName2Type = new HashMap<String, FacetTypeId<? extends JavaeeFacet>>();

    public void registerModule(String moduleName, FacetTypeId<? extends JavaeeFacet> type) {
        this.myModuleName2Type.put(moduleName, type);
    }

    @Nullable
    public String getFacetId(String moduleName) {
        return this.getFacetId(moduleName, false);
    }

    @Nullable
    public String getFacetId(String moduleName, boolean setWebTypeIfFacetNotFound) {
        FacetTypeId typeId = this.getFacetType(moduleName);
        if (typeId == null) {
            if (setWebTypeIfFacetNotFound) {
                typeId = WebFacet.ID;
            } else {
                return null;
            }
        }
        return FacetPointersManager.constructId((String)moduleName, (String)JavaeeConvertingContext.getStringId(typeId), (String)moduleName);
    }

    public static String getStringId(FacetTypeId<? extends JavaeeFacet> type) {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(type);
        if (!(facetType instanceof JavaeeFacetType)) {
            throw new AssertionError(type);
        }
        return facetType.getStringId();
    }

    protected FacetTypeId<? extends JavaeeFacet> getFacetType(String moduleName) {
        return this.myModuleName2Type.get(moduleName);
    }
}

