/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.javaee.converting.artifacts.AbstractPackagingConverter;
import com.intellij.javaee.converting.artifacts.ModuleJarSettingsConversionProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public class JarPackagingConverter
extends AbstractPackagingConverter {
    private List<ArtifactState> myArtifactStates = new ArrayList<ArtifactState>();
    @NonNls
    private static final String BUILD_JAR_PROJECT_SETTINGS_COMPONENT_NAME = "BuildJarProjectSettings";

    public JarPackagingConverter(ConversionContext context) {
        super(context);
    }

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new ModuleJarSettingsConversionProcessor(this);
    }

    @Override
    public Collection<File> getAdditionalAffectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(super.getAdditionalAffectedFiles());
        ComponentManagerSettings settings = this.myContext.getCompilerSettings();
        if (settings != null) {
            files.add(settings.getFile());
        }
        return files;
    }

    public void postProcessingFinished() throws CannotConvertException {
        Element component;
        this.saveArtifacts(this.myArtifactStates);
        ComponentManagerSettings compilerSettings = this.myContext.getCompilerSettings();
        if (compilerSettings != null && (component = compilerSettings.getComponentElement(BUILD_JAR_PROJECT_SETTINGS_COMPONENT_NAME)) != null) {
            component.detach();
        }
    }

    public void addArtifact(ArtifactState state) {
        this.myArtifactStates.add(state);
    }
}

