/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.descriptor;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.util.DirectoryScanner;
import com.intellij.javaee.oss.util.FileWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeDescriptor {
    private final Icon myIcon;
    private final JavaeeIntegration myIntegration;
    private final Class<?> myType;
    private final String myName;
    private final NotNullLazyValue<ConfigFileMetaData> myMeta = new NotNullLazyValue<ConfigFileMetaData>(){

        @NotNull
        protected ConfigFileMetaData compute() {
            ConfigFileMetaData configFileMetaData = JavaeeDescriptor.this.createMeta(JavaeeDescriptor.this.myType, JavaeeDescriptor.this.myName);
            if (configFileMetaData == null) {
                1.$$$reportNull$$$0(0);
            }
            return configFileMetaData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/descriptor/JavaeeDescriptor$1", "compute"));
        }
    };
    private final Set<String> namespaces = new HashSet<String>();

    protected JavaeeDescriptor(Icon icon, JavaeeIntegration integration, Class<?> type, @NonNls String name) {
        this.myIcon = icon;
        this.myIntegration = integration;
        this.myType = type;
        this.myName = name;
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    private ConfigFileMetaData createMeta(Class<?> type, final @NonNls String name) {
        final JavaeeIntegration integration = this.getIntegration();
        final ArrayList versions = new ArrayList();
        new DirectoryScanner(".+\\.xml\\.ft"){

            @Override
            protected void handle(FileWrapper file) throws Exception {
                String template = file.getName().replaceFirst("\\.ft$", "");
                if (name.equals(integration.getNameFromTemplate(template))) {
                    String version = integration.getVersionFromTemplate(template);
                    versions.add(new ConfigFileVersion(version, template));
                    JavaeeDescriptor.this.namespaces.add(JavaeeDescriptor.getNamespace(file));
                }
            }
        }.scan("fileTemplates/j2ee", type);
        ConfigFileVersion[] tmp = versions.toArray(new ConfigFileVersion[versions.size()]);
        Arrays.sort(tmp, (v1, v2) -> StringUtil.compareVersionNumbers((String)v1.getName(), (String)v2.getName()));
        return new ConfigFileMetaData(this.getTitle(integration), name + ".xml", this.getPath(), tmp, null, true, true, true);
    }

    @Nullable
    public <T extends DomElement> T getRoot(@Nullable JavaeeFacet facet, @NotNull Class<T> type) {
        DomFileElement element;
        XmlFile xml;
        ConfigFile item;
        if (type == null) {
            JavaeeDescriptor.$$$reportNull$$$0(0);
        }
        if (facet != null && (item = facet.getDescriptorsContainer().getConfigFile((ConfigFileMetaData)this.myMeta.getValue())) != null && (xml = item.getXmlFile()) != null && (element = DomManager.getDomManager((Project)facet.getModule().getProject()).getFileElement(xml, type)) != null) {
            return (T)element.getRootElement();
        }
        return null;
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaces.contains(namespace);
    }

    public ConfigFileMetaData getMetaData() {
        return (ConfigFileMetaData)this.myMeta.getValue();
    }

    public Icon getIcon() {
        LayeredIcon layered = new LayeredIcon(2);
        layered.setIcon(this.getIntegration().getIcon(), 0);
        layered.setIcon(this.myIcon, 1);
        return layered;
    }

    protected abstract String getTitle(JavaeeIntegration var1);

    protected abstract FacetTypeId<? extends JavaeeFacet> getFacetType();

    @NonNls
    protected String getPath() {
        return "META-INF";
    }

    private static String getNamespace(FileWrapper file) throws JDOMException, IOException {
        Element root = JDOMUtil.loadDocument((InputStream)file.getStream()).getRootElement();
        String namespace = root.getNamespaceURI();
        if (StringUtil.isEmpty((String)namespace)) {
            DocType type = root.getDocument().getDocType();
            namespace = type != null ? type.getSystemID() : "";
        }
        return namespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javaee/oss/descriptor/JavaeeDescriptor", "getRoot"));
    }
}

