/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.RunnerSpecificConfigurationBit;
import com.intellij.openapi.options.SettingsEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RunnerSpecificRemotePanel
extends SettingsEditor<ConfigurationPerRunnerSettings> {
    private final JavaPatchableProgramRunner<?> myJavaProgramRunner;
    private ConfigurationArgumentsHelpArea myHelpArea;

    public RunnerSpecificRemotePanel(JavaPatchableProgramRunner<?> runner) {
        this.myJavaProgramRunner = runner;
    }

    private static String getActionText(JavaPatchableProgramRunner<?> runner) {
        return runner.getRunnerId().toLowerCase();
    }

    public void resetEditorFrom(@NotNull ConfigurationPerRunnerSettings item) {
        if (item == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(0);
        }
        RunnerSpecificConfigurationBit runnerSpecificConfigurationBit = (RunnerSpecificConfigurationBit)item;
        this.updateHelpArea(runnerSpecificConfigurationBit.getParentConfiguration(), runnerSpecificConfigurationBit.getRunnerSettings());
    }

    public void applyEditorTo(@NotNull ConfigurationPerRunnerSettings commonModel) {
        if (commonModel == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public JComponent createEditor() {
        this.myHelpArea = new ConfigurationArgumentsHelpArea();
        this.myHelpArea.setLabelText(J2EEBundle.message((String)"label.run.configuration.editor.add.vm.parameters", (Object[])new Object[]{RunnerSpecificRemotePanel.getActionText(this.myJavaProgramRunner)}));
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea = this.myHelpArea;
        if (configurationArgumentsHelpArea == null) {
            RunnerSpecificRemotePanel.$$$reportNull$$$0(2);
        }
        return configurationArgumentsHelpArea;
    }

    private String evaluatePatchedParameters(CommonStrategy runProfile, RunnerSettings runnerSettings) throws ExecutionException {
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(runProfile.getJre());
        this.myJavaProgramRunner.patch(javaParameters, runnerSettings, (RunProfile)runProfile, false);
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        if (vmParametersList.getArray().length == 0) {
            return J2EEBundle.message((String)"message.text.run.configuration.editor.no.specific.parameters.needed", (Object[])new Object[0]);
        }
        return vmParametersList.getParametersString();
    }

    private void updateHelpArea(CommonStrategy runProfile, RunnerSettings runnerSettings) {
        try {
            this.myHelpArea.updateText(this.evaluatePatchedParameters(runProfile, runnerSettings));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/run/configuration/view/RunnerSpecificRemotePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/run/configuration/view/RunnerSpecificRemotePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

