/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.jam.view.tree.JamTreeStructure;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.ui.FrameworkToolWindowViewBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeToolWindowViewBase
extends FrameworkToolWindowViewBase {
    protected <F extends Facet> JavaeeToolWindowViewBase(Project project, JavaeeFrameworkViewTreeStructureProvider<F> treeStructureProvider) {
        super(project, treeStructureProvider);
        CustomizationUtil.installPopupHandler((JComponent)this.myTree, (String)"J2EEViewPopupMenu", (String)"J2EEViewPopup");
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener(((JavaeeFrameworkViewTreeStructureProvider)treeStructureProvider).myFacetTypeId, (ProjectWideFacetListener)new ProjectWideFacetAdapter<F>(){

            public void facetConfigurationChanged(Facet facet) {
                JavaeeToolWindowViewBase.this.updateTree();
            }

            public void facetRemoved(Facet facet) {
                JavaeeToolWindowViewBase.this.updateTree();
            }

            public void facetAdded(Facet facet) {
                JavaeeToolWindowViewBase.this.updateTree();
            }
        }, (Disposable)this);
    }

    protected abstract String getHelpId();

    public Object getData(String dataId) {
        Object nodeDescriptor;
        DeleteProvider provider;
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpId();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (provider = JamCommonUtil.createDeleteProvider((AbstractTreeBuilder)this.myBuilder)) != null) {
            return provider;
        }
        Set set = this.myBuilder.getSelectedElements();
        if (!set.isEmpty() && (nodeDescriptor = set.iterator().next()) instanceof JamNodeDescriptor && ((JamNodeDescriptor)nodeDescriptor).isValid()) {
            return ((JamNodeDescriptor)nodeDescriptor).getDataForElement(dataId);
        }
        return null;
    }

    @Nullable
    private static JavaeeToolWindowViewBase getView(Project project, String toolWindowId) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
        Content content = window == null ? null : window.getContentManager().getContent(0);
        return content == null ? null : (JavaeeToolWindowViewBase)content.getDisposer();
    }

    protected static void select(String toolWindowId, Project project, Object[] path, boolean requestFocus) {
        if (path == null) {
            return;
        }
        Runnable runnable = () -> {
            JavaeeToolWindowViewBase view = JavaeeToolWindowViewBase.getView(project, toolWindowId);
            if (view == null || view.myBuilder == null) {
                return;
            }
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)view.myTree, true);
            }
            JavaeeUtil.selectPath((AbstractTreeBuilder)view.myBuilder, path);
        };
        if (requestFocus) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
            if (toolWindow != null) {
                toolWindow.activate(runnable);
            }
        } else {
            runnable.run();
        }
    }

    protected static abstract class JavaeeFrameworkViewTreeStructureProvider<F extends Facet>
    extends FrameworkToolWindowViewBase.FrameworkViewTreeStructureProvider {
        private FacetTypeId<F> myFacetTypeId;

        protected JavaeeFrameworkViewTreeStructureProvider(FacetTypeId<F> facetTypeId) {
            this.myFacetTypeId = facetTypeId;
        }

        protected abstract JamNodeDescriptor createFacetNodeDescriptor(F var1, NodeDescriptor<?> var2, JamTreeParameters var3);

        public JamTreeStructure createTreeStructure(final @NotNull Project project) {
            if (project == null) {
                JavaeeFrameworkViewTreeStructureProvider.$$$reportNull$$$0(0);
            }
            return JamTreeStructure.asyncInstance((SimpleNode)new JamNodeDescriptor<Project>(project, null, (Object)new J2EEModuleParameters(true), project){

                public SimpleNode[] getChildren() {
                    1 rootDescriptor = this;
                    JamTreeParameters treeParameters = (JamTreeParameters)this.getParameters();
                    return (SimpleNode[])ContainerUtil.map2Array((Collection)ProjectFacetManager.getInstance((Project)project).getFacets(myFacetTypeId), JamNodeDescriptor.class, f -> this.createFacetNodeDescriptor(f, (NodeDescriptor<?>)rootDescriptor, treeParameters));
                }

                protected String getNewNodeText() {
                    return project.getName();
                }
            }, (Project)project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ui/JavaeeToolWindowViewBase$JavaeeFrameworkViewTreeStructureProvider", "createTreeStructure"));
        }
    }
}

