/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetPackagingElementBase
extends PackagingElement<FacetPackagingElementState>
implements FacetBasedPackagingElement {
    @NonNls
    public static final String FACET_ATTRIBUTE = "facet";
    protected FacetPointer<JavaeeFacet> myFacetPointer;
    private final Project myProject;

    public FacetPackagingElementBase(@NotNull PackagingElementType type, @NotNull Project project, @Nullable FacetPointer<JavaeeFacet> facetPointer) {
        if (type == null) {
            FacetPackagingElementBase.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FacetPackagingElementBase.$$$reportNull$$$0(1);
        }
        super(type);
        this.myProject = project;
        this.myFacetPointer = facetPointer;
    }

    public FacetPackagingElementState getState() {
        FacetPackagingElementState state = new FacetPackagingElementState();
        if (this.myFacetPointer != null) {
            state.setFacetId(this.myFacetPointer.getId());
        }
        return state;
    }

    public void loadState(FacetPackagingElementState state) {
        String facetId = state.getFacetId();
        this.myFacetPointer = facetId != null ? FacetPointersManager.getInstance((Project)this.myProject).create(facetId) : null;
    }

    public FacetPointer<JavaeeFacet> getFacetPointer() {
        return this.myFacetPointer;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            FacetPackagingElementBase.$$$reportNull$$$0(2);
        }
        return ((Object)((Object)this)).getClass() == element.getClass() && this.myFacetPointer != null && this.myFacetPointer.equals(((FacetPackagingElementBase)element).myFacetPointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JavaeeFacet findFacet(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            FacetPackagingElementBase.$$$reportNull$$$0(3);
        }
        AccessToken token = ReadAction.start();
        try {
            JavaeeFacet javaeeFacet = (JavaeeFacet)this.myFacetPointer.findFacet(context.getModulesProvider(), context.getFacetsProvider());
            return javaeeFacet;
        }
        finally {
            token.finish();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/ui/packaging/FacetPackagingElementBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFacet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FacetPackagingElementState {
        private String myFacetId;

        @Attribute(value="facet")
        public String getFacetId() {
            return this.myFacetId;
        }

        public void setFacetId(String facetId) {
            this.myFacetId = facetId;
        }
    }
}

