/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.script.QueryParametersProvider;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.ql.psi.impl.QlFileImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.util.QueryParameterResolveHelper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JpaQueryParameterReferenceProvider
extends PsiReferenceProvider {
    private final ResolveHelper myHelper = new ResolveHelper();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(1);
        }
        String parameterName = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
        PsiReference[] psiReferenceArray = new PsiReference[]{new QueryParameterReference(element, parameterName, this.myHelper)};
        if (psiReferenceArray == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            JpaQueryParameterReferenceProvider.$$$reportNull$$$0(3);
        }
        return target instanceof QlFileImpl.ParameterDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaQueryParameterReferenceProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaQueryParameterReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryParameterReference
    extends JpaQueryReferenceProvider.QueryRelatedReference {
        private final String myParameterName;
        private final ResolveHelper myHelper;
        private List<Map<String, PsiElement>> myMapList;
        private boolean myUnparsable;

        public QueryParameterReference(PsiElement element, String parameterName, ResolveHelper helper) {
            super(element);
            this.myParameterName = parameterName;
            this.myHelper = helper;
        }

        private void initMapList() {
            if (this.myMapList == null) {
                this.myMapList = new ArrayList<Map<String, PsiElement>>(0);
                Ref ref = Ref.create(null);
                this.myHelper.processPossibleQueryElementsByParameter(CompletionUtil.getOriginalOrSelf((PsiElement)this.getElement()), this.myMapList, (Ref<Boolean>)ref);
                this.myUnparsable = Boolean.TRUE.equals(ref.get());
            }
        }

        public PsiElement resolve() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                return this.getElement();
            }
            if (StringUtil.isEmpty((String)this.myParameterName)) {
                return null;
            }
            for (Map<String, PsiElement> map : this.myMapList) {
                PsiElement element = map.get(this.myParameterName);
                if (element == null) continue;
                return element;
            }
            return this.myUnparsable ? this.getElement() : null;
        }

        @NotNull
        public Object[] getVariants() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    QueryParameterReference.$$$reportNull$$$0(0);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            HashMap<String, PsiElement> result = new HashMap<String, PsiElement>(this.myMapList.get(0));
            for (Map<String, PsiElement> map : this.myMapList) {
                result.keySet().retainAll(map.keySet());
            }
            Object[] objectArray = ContainerUtil.mapNotNull(result.keySet(), s -> {
                if (StringUtil.parseInt((String)s, (int)-1) != -1) {
                    return null;
                }
                return LookupElementBuilder.create((String)s).withIcon(((PsiElement)result.get(s)).getIcon(0));
            }).toArray();
            if (objectArray == null) {
                QueryParameterReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.parameter.0", (Object[])new Object[0]);
            if (string == null) {
                QueryParameterReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/JpaQueryParameterReferenceProvider$QueryParameterReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ResolveHelper
    extends QueryParameterResolveHelper<Map<String, PsiElement>, Ref<Boolean>> {
        @Override
        protected boolean addParamMap(@NotNull PsiFile file, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            QueryParametersProvider provider;
            if (file == null) {
                ResolveHelper.$$$reportNull$$$0(0);
            }
            if ((provider = (QueryParametersProvider)QueryParametersProvider.EXTENSION.forLanguage(file.getLanguage())) == null) {
                return false;
            }
            ContainerUtil.addIfNotNull(result, (Object)provider.getParameters(file));
            if (context.isNull()) {
                context.set(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
                if (PsiTreeUtil.hasErrorElements((PsiElement)file)) {
                    context.set((Object)true);
                }
            }
            return true;
        }

        @Override
        public boolean processPossibleQueryElementsByParameter(PsiElement paramElement, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)paramElement, PsiMethodCallExpression.class);
            if (expression == null) {
                return false;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length > 0 && !args[0].equals(paramElement) && this.processPossibleQueryElement((PsiElement)args[0], result, ResolveHelper.initialVisitedElements(paramElement), context)) {
                return true;
            }
            return super.processPossibleQueryElementsByParameter(paramElement, result, context);
        }

        @Override
        protected boolean processPossibleQueryElement(PsiElement element, List<Map<String, PsiElement>> result, Collection<PsiElement> visitedElements, Ref<Boolean> context) {
            if (element instanceof XmlElement) {
                return this.addParamMapsByQueryElement(element, result, context);
            }
            return super.processPossibleQueryElement(element, result, visitedElements, context);
        }

        @Override
        protected boolean addParamMapsByQueryElement(@NotNull PsiElement expression, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            GenericValue queryValue;
            JpaQueryReferenceProvider.QueryReference reference;
            if (expression == null) {
                ResolveHelper.$$$reportNull$$$0(1);
            }
            PersistenceQuery query = (reference = JpaUtil.findReferenceOfType(expression.getReferences(), JpaQueryReferenceProvider.QueryReference.class)) == null ? null : reference.resolveQuery();
            GenericValue genericValue = queryValue = query == null ? null : query.getQuery();
            if (queryValue instanceof JamAttributeElement) {
                PsiLiteralExpression literal;
                PsiAnnotationMemberValue value = ((JamAttributeElement)queryValue).getPsiElement();
                if (value instanceof PsiReferenceExpression) {
                    this.addParameterMapsByQueryReference((PsiReferenceExpression)value, result, ResolveHelper.initialVisitedElements(expression), context);
                } else if (value instanceof PsiExpression && (literal = ResolveHelper.getFirstLiteral((PsiExpression)value)) != null) {
                    this.addParamMapsByQueryElement((PsiElement)literal, result, context);
                }
                return true;
            }
            if (queryValue instanceof DomElement) {
                XmlElement element = ((DomElement)queryValue).getXmlElement();
                if (element != null) {
                    super.addParamMapsByQueryElement((PsiElement)element, result, context);
                }
                return true;
            }
            return super.addParamMapsByQueryElement(expression, result, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/JpaQueryParameterReferenceProvider$ResolveHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParamMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParamMapsByQueryElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

