/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamElement;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.Basic;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.RemoveQuickFix;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JpaAttributeMemberSignatureInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.attribute.member.signature", (Object[])new Object[0]);
        if (string == null) {
            JpaAttributeMemberSignatureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaAttributeMemberSignatureInspection" == null) {
            JpaAttributeMemberSignatureInspection.$$$reportNull$$$0(1);
        }
        return "JpaAttributeMemberSignatureInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getPersistentObject() != null) {
            JpaAttributeMemberSignatureInspection.checkObjectMembers(aClass, role.getPersistentObject(), role, holder);
        }
    }

    private static void checkObjectMembers(PsiClass aClass, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        Processor processor = psiMember -> {
            JpaAttributeMemberSignatureInspection.checkObjectMember(psiMember, object, role, holder);
            return true;
        };
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    private static void checkObjectMember(PsiMember member, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        boolean isMethod = member instanceof PsiMethod;
        PsiIdentifier anchor = isMethod ? ((PsiMethod)member).getNameIdentifier() : ((PsiField)member).getNameIdentifier();
        List attributes = browser.getPersistenceAttributes(object, member);
        Collection<LocalQuickFix> quickFixes = JpaAttributeMemberSignatureInspection.checkMoreThanOneAttributeConfigured(attributes);
        if (!quickFixes.isEmpty()) {
            holder.registerProblem((PsiElement)anchor, JpaHighlightingMessages.message(isMethod ? "more.than.one.attribute.configured.for.method" : "more.than.one.attribute.configured.for.field", member.getName()), quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
        }
        if (!attributes.isEmpty()) {
            JpaAttributeMemberSignatureInspection.checkAttributeMembers(member, holder, role);
        }
        ModelValidator validator = role.getFacet().getModelValidator(role.getPersistenceUnit());
        for (PersistentAttribute attribute : attributes) {
            JpaAttributeMemberSignatureInspection.checkAttributeType(member, holder, role, attribute);
        }
    }

    private static Collection<LocalQuickFix> checkMoreThanOneAttributeConfigured(List<PersistentAttribute> attributes) {
        THashMap valueMap = new THashMap(1);
        boolean[] problemFound = new boolean[]{false};
        ContainerUtil.process(attributes, (Processor)ModelMergerUtil.createFilteringProcessor(arg_0 -> JpaAttributeMemberSignatureInspection.lambda$checkMoreThanOneAttributeConfigured$1((Map)valueMap, problemFound, arg_0)));
        if (problemFound[0]) {
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            Processor processor = attributeBase -> {
                PsiElement targetElement;
                Object object = attributeBase instanceof AttributeBaseImpl ? ((AttributeBaseImpl)((Object)attributeBase)).getAnnoRef().getPsiElement() : (targetElement = attributeBase instanceof DomElement ? ((DomElement)attributeBase).getXmlElement() : null);
                if (targetElement != null) {
                    quickFixes.add(new RemoveQuickFix(targetElement));
                }
                return true;
            };
            for (Object key : valueMap.keySet()) {
                Set set = (Set)valueMap.get(key);
                if (set.size() <= 1) continue;
                ContainerUtil.process((Iterable)set, (Processor)processor);
            }
            return quickFixes;
        }
        return Collections.emptyList();
    }

    private static void checkAttributeMembers(PsiMember psiMember, ProblemsHolder holder, PersistenceClassRole role) {
        if (psiMember instanceof PsiMethod) {
            PsiElement element;
            PsiMethod propertySetter;
            PsiMethod method = (PsiMethod)psiMember;
            if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
                holder.registerProblem(JpaAttributeMemberSignatureInspection.getProblemElement(method), JpaHighlightingMessages.message("attribute.member.should.be.field.or.getter", new Object[0]), new LocalQuickFix[0]);
            } else if (role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS && ((propertySetter = PropertyUtil.findPropertySetter((PsiClass)psiMember.getContainingClass(), (String)PropertyUtil.getPropertyNameByGetter((PsiMethod)method), (boolean)false, (boolean)true)) == null || !Comparing.equal((Object)PropertyUtil.getPropertyType((PsiMember)propertySetter), (Object)PropertyUtil.getPropertyType((PsiMember)method))) && (element = JpaAttributeMemberSignatureInspection.getProblemElement(method)).isPhysical()) {
                holder.registerProblem(element, JpaHighlightingMessages.message("attribute.definition.lacks.setter", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (!(psiMember instanceof PsiField)) {
            holder.registerProblem((PsiElement)psiMember, JpaHighlightingMessages.message("attribute.member.should.be.field.or.getter", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static PsiElement getProblemElement(@NotNull PsiMethod method) {
        PsiIdentifier nameIdentifier;
        if (method == null) {
            JpaAttributeMemberSignatureInspection.$$$reportNull$$$0(2);
        }
        Object object = (nameIdentifier = method.getNameIdentifier()) != null && nameIdentifier.isValid() && nameIdentifier.isPhysical() ? nameIdentifier : method;
        if (object == null) {
            JpaAttributeMemberSignatureInspection.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static void checkAttributeType(PsiMember psiMember, ProblemsHolder holder, PersistenceClassRole role, PersistentAttribute attribute) {
        PersistenceFacet facet = role.getFacet();
        if (!JpaUtil.isHibernateProvider(role) && facet instanceof JpaFacet && JpaUtil.getJpaVersion((JpaFacet)facet) == JpaVersion.JPA_1_0 && role.getType() == PersistenceClassRoleEnum.EMBEDDABLE && !(attribute instanceof Basic) && !(attribute instanceof PersistentTransientAttribute)) {
            String attributeTypeName = AttributeType.getAttributeType((PersistentAttribute)attribute).getTypeName();
            String attributeName = (String)attribute.getName().getValue();
            PsiIdentifier propertyIdentifier = PropertyUtil.getPropertyNameIdentifier((PsiMember)psiMember);
            holder.registerProblem((PsiElement)propertyIdentifier, JpaHighlightingMessages.message("attribute.type.not.valid.for.embeddable", attributeTypeName, attributeName), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ boolean lambda$checkMoreThanOneAttributeConfigured$1(Map valueMap, boolean[] problemFound, PersistentAttribute o) {
        Object key = o instanceof DomElement ? DomUtil.getParentOfType((DomElement)((DomElement)o), PersistentObject.class, (boolean)true) : (o instanceof JamElement ? Boolean.TRUE : null);
        if (key != null) {
            Set set = (Set)valueMap.get(key);
            if (set == null) {
                set = new THashSet(1);
                valueMap.put(key, set);
            } else if (!problemFound[0]) {
                problemFound[0] = true;
            }
            set.add(o);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/inspections/JpaAttributeMemberSignatureInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/inspections/JpaAttributeMemberSignatureInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

