/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.parser;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlParserDefinition;
import com.intellij.jpa.ql.parser._QlLexer;
import com.intellij.jpa.ql.psi.QlTokenType;
import com.intellij.lang.Language;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QlLexer
extends LookAheadLexer {
    public static final Map<String, IElementType> HQL_KEYWORDS = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    public static final Map<String, IElementType> EJB_KEYWORDS = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    public static final Map<String, IElementType> JPA_KEYWORDS = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    public static final Map<String, IElementType> EQL_KEYWORDS = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private static final Set<String> optionalKeywords = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    public static final Set<String> HQL_DATETIME_TYPES = new THashSet();
    public static final Set<String> HQL_NUMERIC_TYPES = new THashSet();
    public static final Set<String> HQL_ALL_TYPES = new THashSet();
    public static final IElementType QL_QUAL_IDENTIFIER = new QlTokenType("identifier");
    public static final IElementType QL_IDENTIFIER = new QlTokenType("identifier");
    public static final IElementType QL_STRING_UNCLOSED = new QlTokenType("unclosed string");
    public static final TokenSet QL_BINARY_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{QlTypes.QL_OP_PLUS, QlTypes.QL_OP_MINUS, QlTypes.QL_OP_CONCAT, QlTypes.QL_OP_DIV, QlTypes.QL_OP_MUL, QlTypes.QL_OP_EQ, QlTypes.QL_OP_GE, QlTypes.QL_OP_GT, QlTypes.QL_OP_LE, QlTypes.QL_OP_LT, QlTypes.QL_OP_NE});
    private final Map<String, IElementType> myKeywordMap;

    public static boolean isOptionalKeyword(String s) {
        return optionalKeywords.contains(s);
    }

    @NotNull
    public static Map<String, IElementType> getKeywordMap(@NotNull Language language) {
        if (language == null) {
            QlLexer.$$$reportNull$$$0(0);
        }
        Map<String, IElementType> map = language == JpqlLanguage.EJBQL ? EJB_KEYWORDS : (language == JpqlLanguage.HQL ? HQL_KEYWORDS : (language == JpqlLanguage.EQL ? EQL_KEYWORDS : JPA_KEYWORDS));
        if (map == null) {
            QlLexer.$$$reportNull$$$0(1);
        }
        return map;
    }

    public QlLexer(@NotNull Language language) {
        if (language == null) {
            QlLexer.$$$reportNull$$$0(2);
        }
        super((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _QlLexer()), QlParserDefinition.WS));
        this.myKeywordMap = QlLexer.getKeywordMap(language);
    }

    public Set<String> getKeywords() {
        return this.myKeywordMap.keySet();
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType elementType;
        if (baseLexer.getTokenType() == QL_QUAL_IDENTIFIER) {
            this.advanceAs(baseLexer, QL_IDENTIFIER);
            return;
        }
        IElementType iElementType = elementType = baseLexer.getTokenType() == QL_IDENTIFIER ? this.myKeywordMap.get(baseLexer.getTokenText()) : null;
        if (elementType != null) {
            this.advanceAs(baseLexer, elementType);
        }
        super.lookAhead(baseLexer);
    }

    static {
        ContainerUtil.addAll(optionalKeywords, (Object[])new String[]{"ORDER", "GROUP", "MAX", "MIN", "KEY", "VALUE", "ENTRY", "MAP", "LIST", "ABS", "OBJECT", "AVG", "SUM", "COUNT", "EXTRACT", "CAST", "LOCATE", "ABS", "SQRT", "MOD", "INDEX", "MINELEMENT", "MAXELEMENT", "MININDEX", "MAXINDEX", "COALESCE", "NULLIF"});
        ContainerUtil.addAll(HQL_DATETIME_TYPES, (Object[])new String[]{"second", "minute", "hour", "day", "month", "quarter", "year"});
        ContainerUtil.addAll(HQL_NUMERIC_TYPES, (Object[])new String[]{"integer", "long", "short", "byte", "character", "float", "double", "char"});
        ContainerUtil.addAll(HQL_ALL_TYPES, HQL_NUMERIC_TYPES);
        ContainerUtil.addAll(HQL_ALL_TYPES, (Object[])new String[]{"string", "boolean"});
        EJB_KEYWORDS.put("BY", QlTypes.QL_BY);
        EJB_KEYWORDS.put("COUNT", QlTypes.QL_COUNT);
        EJB_KEYWORDS.put("LIKE", QlTypes.QL_LIKE);
        EJB_KEYWORDS.put("OF", QlTypes.QL_OF);
        EJB_KEYWORDS.put("MOD", QlTypes.QL_MOD);
        EJB_KEYWORDS.put("WHERE", QlTypes.QL_WHERE);
        EJB_KEYWORDS.put("TRUE", QlTypes.QL_TRUE);
        EJB_KEYWORDS.put("IS", QlTypes.QL_IS);
        EJB_KEYWORDS.put("IN", QlTypes.QL_IN);
        EJB_KEYWORDS.put("EMPTY", QlTypes.QL_EMPTY);
        EJB_KEYWORDS.put("AVG", QlTypes.QL_AVG);
        EJB_KEYWORDS.put("MAX", QlTypes.QL_MAX);
        EJB_KEYWORDS.put("ORDER", QlTypes.QL_ORDER);
        EJB_KEYWORDS.put("AS", QlTypes.QL_AS);
        EJB_KEYWORDS.put("NULL", QlTypes.QL_NULL);
        EJB_KEYWORDS.put("MIN", QlTypes.QL_MIN);
        EJB_KEYWORDS.put("DISTINCT", QlTypes.QL_DISTINCT);
        EJB_KEYWORDS.put("DESC", QlTypes.QL_DESC);
        EJB_KEYWORDS.put("AND", QlTypes.QL_AND);
        EJB_KEYWORDS.put("MEMBER", QlTypes.QL_MEMBER);
        EJB_KEYWORDS.put("BETWEEN", QlTypes.QL_BETWEEN);
        EJB_KEYWORDS.put("SUM", QlTypes.QL_SUM);
        EJB_KEYWORDS.put("FALSE", QlTypes.QL_FALSE);
        EJB_KEYWORDS.put("ASC", QlTypes.QL_ASC);
        EJB_KEYWORDS.put("OBJECT", QlTypes.QL_OBJECT);
        EJB_KEYWORDS.put("NOT", QlTypes.QL_NOT);
        EJB_KEYWORDS.put("FROM", QlTypes.QL_FROM);
        EJB_KEYWORDS.put("SELECT", QlTypes.QL_SELECT);
        EJB_KEYWORDS.put("OR", QlTypes.QL_OR);
        EJB_KEYWORDS.put("CONCAT", QlTypes.QL_CONCAT);
        EJB_KEYWORDS.put("SUBSTRING", QlTypes.QL_SUBSTRING);
        EJB_KEYWORDS.put("LOCATE", QlTypes.QL_LOCATE);
        EJB_KEYWORDS.put("LENGTH", QlTypes.QL_LENGTH);
        EJB_KEYWORDS.put("ABS", QlTypes.QL_ABS);
        EJB_KEYWORDS.put("SQRT", QlTypes.QL_SQRT);
        JPA_KEYWORDS.putAll(EJB_KEYWORDS);
        JPA_KEYWORDS.put("THEN", QlTypes.QL_THEN);
        JPA_KEYWORDS.put("TRAILING", QlTypes.QL_TRAILING);
        JPA_KEYWORDS.put("SOME", QlTypes.QL_SOME);
        JPA_KEYWORDS.put("AVG", QlTypes.QL_AVG);
        JPA_KEYWORDS.put("JOIN", QlTypes.QL_JOIN);
        JPA_KEYWORDS.put("HAVING", QlTypes.QL_HAVING);
        JPA_KEYWORDS.put("SET", QlTypes.QL_SET);
        JPA_KEYWORDS.put("NULLIF", QlTypes.QL_NULLIF);
        JPA_KEYWORDS.put("SUBSTRING", QlTypes.QL_SUBSTRING);
        JPA_KEYWORDS.put("LIKE", QlTypes.QL_LIKE);
        JPA_KEYWORDS.put("MAX", QlTypes.QL_MAX);
        JPA_KEYWORDS.put("INNER", QlTypes.QL_INNER);
        JPA_KEYWORDS.put("SQRT", QlTypes.QL_SQRT);
        JPA_KEYWORDS.put("KEY", QlTypes.QL_KEY);
        JPA_KEYWORDS.put("EMPTY", QlTypes.QL_EMPTY);
        JPA_KEYWORDS.put("SUM", QlTypes.QL_SUM);
        JPA_KEYWORDS.put("MIN", QlTypes.QL_MIN);
        JPA_KEYWORDS.put("ENTRY", QlTypes.QL_ENTRY);
        JPA_KEYWORDS.put("OF", QlTypes.QL_OF);
        JPA_KEYWORDS.put("OR", QlTypes.QL_OR);
        JPA_KEYWORDS.put("TRIM", QlTypes.QL_TRIM);
        JPA_KEYWORDS.put("NEW", QlTypes.QL_NEW);
        JPA_KEYWORDS.put("ELSE", QlTypes.QL_ELSE);
        JPA_KEYWORDS.put("IS", QlTypes.QL_IS);
        JPA_KEYWORDS.put("FETCH", QlTypes.QL_FETCH);
        JPA_KEYWORDS.put("OBJECT", QlTypes.QL_OBJECT);
        JPA_KEYWORDS.put("IN", QlTypes.QL_IN);
        JPA_KEYWORDS.put("DESC", QlTypes.QL_DESC);
        JPA_KEYWORDS.put("ASC", QlTypes.QL_ASC);
        JPA_KEYWORDS.put("ESCAPE", QlTypes.QL_ESCAPE);
        JPA_KEYWORDS.put("CURRENT_TIME", QlTypes.QL_CURRENT_TIME);
        JPA_KEYWORDS.put("UPPER", QlTypes.QL_UPPER);
        JPA_KEYWORDS.put("ANY", QlTypes.QL_ANY);
        JPA_KEYWORDS.put("WHERE", QlTypes.QL_WHERE);
        JPA_KEYWORDS.put("VALUE", QlTypes.QL_VALUE);
        JPA_KEYWORDS.put("CURRENT_DATE", QlTypes.QL_CURRENT_DATE);
        JPA_KEYWORDS.put("FALSE", QlTypes.QL_FALSE);
        JPA_KEYWORDS.put("MEMBER", QlTypes.QL_MEMBER);
        JPA_KEYWORDS.put("BETWEEN", QlTypes.QL_BETWEEN);
        JPA_KEYWORDS.put("NULL", QlTypes.QL_NULL);
        JPA_KEYWORDS.put("AND", QlTypes.QL_AND);
        JPA_KEYWORDS.put("GROUP", QlTypes.QL_GROUP);
        JPA_KEYWORDS.put("LEFT", QlTypes.QL_LEFT);
        JPA_KEYWORDS.put("COALESCE", QlTypes.QL_COALESCE);
        JPA_KEYWORDS.put("CURRENT_TIMESTAMP", QlTypes.QL_CURRENT_TIMESTAMP);
        JPA_KEYWORDS.put("BY", QlTypes.QL_BY);
        JPA_KEYWORDS.put("LOWER", QlTypes.QL_LOWER);
        JPA_KEYWORDS.put("SELECT", QlTypes.QL_SELECT);
        JPA_KEYWORDS.put("MOD", QlTypes.QL_MOD);
        JPA_KEYWORDS.put("NOT", QlTypes.QL_NOT);
        JPA_KEYWORDS.put("OUTER", QlTypes.QL_OUTER);
        JPA_KEYWORDS.put("CASE", QlTypes.QL_CASE);
        JPA_KEYWORDS.put("WHEN", QlTypes.QL_WHEN);
        JPA_KEYWORDS.put("BOTH", QlTypes.QL_BOTH);
        JPA_KEYWORDS.put("TYPE", QlTypes.QL_TYPE);
        JPA_KEYWORDS.put("UPDATE", QlTypes.QL_UPDATE);
        JPA_KEYWORDS.put("LEADING", QlTypes.QL_LEADING);
        JPA_KEYWORDS.put("ORDER", QlTypes.QL_ORDER);
        JPA_KEYWORDS.put("AS", QlTypes.QL_AS);
        JPA_KEYWORDS.put("FROM", QlTypes.QL_FROM);
        JPA_KEYWORDS.put("LENGTH", QlTypes.QL_LENGTH);
        JPA_KEYWORDS.put("DISTINCT", QlTypes.QL_DISTINCT);
        JPA_KEYWORDS.put("ALL", QlTypes.QL_ALL);
        JPA_KEYWORDS.put("COUNT", QlTypes.QL_COUNT);
        JPA_KEYWORDS.put("TRUE", QlTypes.QL_TRUE);
        JPA_KEYWORDS.put("SIZE", QlTypes.QL_SIZE);
        JPA_KEYWORDS.put("DELETE", QlTypes.QL_DELETE);
        JPA_KEYWORDS.put("CONCAT", QlTypes.QL_CONCAT);
        JPA_KEYWORDS.put("INDEX", QlTypes.QL_INDEX);
        JPA_KEYWORDS.put("EXISTS", QlTypes.QL_EXISTS);
        JPA_KEYWORDS.put("LOCATE", QlTypes.QL_LOCATE);
        JPA_KEYWORDS.put("END", QlTypes.QL_END);
        JPA_KEYWORDS.put("ON", QlTypes.QL_ON);
        JPA_KEYWORDS.put("FUNCTION", QlTypes.QL_FUNCTION);
        JPA_KEYWORDS.put("TREAT", QlTypes.QL_TREAT);
        EQL_KEYWORDS.putAll(JPA_KEYWORDS);
        EQL_KEYWORDS.put("FUNC", QlTypes.QL_FUNC);
        EQL_KEYWORDS.put("SQl", QlTypes.QL_SQL);
        EQL_KEYWORDS.put("OPERATOR", QlTypes.QL_OPERATOR);
        EQL_KEYWORDS.put("TABLE", QlTypes.QL_TABLE);
        EQL_KEYWORDS.put("COLUMN", QlTypes.QL_COLUMN);
        EQL_KEYWORDS.put("UNION", QlTypes.QL_UNION);
        EQL_KEYWORDS.put("EXCEPT", QlTypes.QL_EXCEPT);
        EQL_KEYWORDS.put("INTERSECT", QlTypes.QL_INTERSECT);
        EQL_KEYWORDS.put("NULLS", QlTypes.QL_NULLS);
        EQL_KEYWORDS.put("FIRST", QlTypes.QL_FIRST);
        HQL_KEYWORDS.putAll(JPA_KEYWORDS);
        HQL_KEYWORDS.put("CAST", QlTypes.QL_CAST);
        HQL_KEYWORDS.put("YES", QlTypes.QL_YES);
        HQL_KEYWORDS.put("QUEST", QlTypes.QL_QUEST);
        HQL_KEYWORDS.put("FULL", QlTypes.QL_FULL);
        HQL_KEYWORDS.put("INSERT", QlTypes.QL_INSERT);
        HQL_KEYWORDS.put("VERSIONED", QlTypes.QL_VERSIONED);
        HQL_KEYWORDS.put("INTO", QlTypes.QL_INTO);
        HQL_KEYWORDS.put("NO", QlTypes.QL_NO);
        HQL_KEYWORDS.put("NUMBER", QlTypes.QL_NUMBER);
        HQL_KEYWORDS.put("SEMICOLON", QlTypes.QL_SEMICOLON);
        HQL_KEYWORDS.put("INDICES", QlTypes.QL_INDICES);
        HQL_KEYWORDS.put("LIST", QlTypes.QL_LIST);
        HQL_KEYWORDS.put("CLASS", QlTypes.QL_CLASS);
        HQL_KEYWORDS.put("PROPERTIES", QlTypes.QL_PROPERTIES);
        HQL_KEYWORDS.put("COMMA", QlTypes.QL_COMMA);
        HQL_KEYWORDS.put("EXTRACT", QlTypes.QL_EXTRACT);
        HQL_KEYWORDS.put("MINELEMENT", QlTypes.QL_MINELEMENT);
        HQL_KEYWORDS.put("WITH", QlTypes.QL_WITH);
        HQL_KEYWORDS.put("RIGHT", QlTypes.QL_RIGHT);
        HQL_KEYWORDS.put("ELEMENTS", QlTypes.QL_ELEMENTS);
        HQL_KEYWORDS.put("MAXELEMENT", QlTypes.QL_MAXELEMENT);
        HQL_KEYWORDS.put("COLON", QlTypes.QL_COLON);
        HQL_KEYWORDS.put("MAXINDEX", QlTypes.QL_MAXINDEX);
        HQL_KEYWORDS.put("MAP", QlTypes.QL_MAP);
        HQL_KEYWORDS.put("MININDEX", QlTypes.QL_MININDEX);
        HQL_KEYWORDS.put("STRING", QlTypes.QL_STRING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ql/parser/QlLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ql/parser/QlLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordMap";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

