/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerConfigurable;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.MavenRepositoriesConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenImportingConfigurable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningConfigurable;

public class MavenSettings
implements SearchableConfigurable.Parent {
    public static final String DISPLAY_NAME = "Maven";
    private final Project myProject;
    private final Configurable myConfigurable;
    private final List<Configurable> myChildren;

    public MavenSettings(@NotNull Project project) {
        if (project == null) {
            MavenSettings.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfigurable = new MavenGeneralConfigurable(){

            @Override
            protected MavenGeneralSettings getState() {
                return MavenProjectsManager.getInstance(MavenSettings.this.myProject).getGeneralSettings();
            }
        };
        this.myChildren = new ArrayList<Configurable>();
        this.myChildren.add((Configurable)new MavenImportingConfigurable(this.myProject));
        this.myChildren.add((Configurable)new MavenIgnoredFilesConfigurable(this.myProject));
        this.myChildren.add((Configurable)new MyMavenRunnerConfigurable(project));
        this.myChildren.add((Configurable)new MavenTestRunningConfigurable(project));
        if (!this.myProject.isDefault()) {
            this.myChildren.add((Configurable)new MavenRepositoriesConfigurable(this.myProject));
        }
    }

    public boolean hasOwnContent() {
        return true;
    }

    public JComponent createComponent() {
        return this.myConfigurable.createComponent();
    }

    public boolean isModified() {
        return this.myConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    public Configurable[] getConfigurables() {
        return this.myChildren.toArray(new Configurable[this.myChildren.size()]);
    }

    @NotNull
    public String getId() {
        String string = MavenSettings.class.getSimpleName();
        if (string == null) {
            MavenSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return this.myConfigurable.getHelpTopic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyMavenRunnerConfigurable
    extends MavenRunnerConfigurable {
        public MyMavenRunnerConfigurable(Project project) {
            super(project, false);
        }

        @Override
        protected MavenRunnerSettings getState() {
            return MavenRunner.getInstance(this.myProject).getState();
        }
    }
}

