/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.dependencies;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsRepositoryLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;

public class DependencyResolvingBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.dependencies.DependencyResolvingBuilder");
    private static final String NAME = "Maven Dependency Resolver";
    private static final String MAVEN_REPOSITORY_PATH_VAR = "MAVEN_REPOSITORY";
    private static final String DEFAULT_MAVEN_REPOSITORY_PATH = ".m2/repository";
    private static final Key<ArtifactRepositoryManager> MANAGER_KEY = Key.create((String)"_artifact_repository_manager_");
    private static final Key<Exception> RESOLVE_ERROR_KEY = Key.create((String)"_artifact_repository_resolve_error_");

    public DependencyResolvingBuilder() {
        super(BuilderCategory.INITIAL);
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (NAME == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    public void buildStarted(CompileContext context) {
        ResourceGuard.init(context);
    }

    @Override
    public void chunkBuildStarted(CompileContext context, ModuleChunk chunk) {
        try {
            DependencyResolvingBuilder.resolveMissingDependencies(context, chunk.getModules());
        }
        catch (Exception e) {
            context.putUserData(RESOLVE_ERROR_KEY, e);
        }
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        Exception error = (Exception)context.getUserData(RESOLVE_ERROR_KEY);
        if (error != null) {
            return DependencyResolvingBuilder.reportError(context, chunk.getPresentableShortName(), error);
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    @NotNull
    static ModuleLevelBuilder.ExitCode reportError(CompileContext context, String placePresentableName, Exception error) {
        StringBuilder builder = new StringBuilder().append("Error resolving dependencies for ").append(placePresentableName);
        HashSet<Exception> processed = new HashSet<Exception>();
        HashSet<String> detailsMessage = new HashSet<String>();
        for (Throwable th = error; th != null && processed.add((Exception)th); th = th.getCause()) {
            String details = th.getMessage();
            if (th instanceof UnknownHostException) {
                details = "Unknown host: " + details;
            }
            if (details == null || !detailsMessage.add(details)) continue;
            builder.append(":\n").append(details);
        }
        String msg = builder.toString();
        LOG.info(msg, (Throwable)error);
        context.processMessage(new CompilerMessage(NAME, BuildMessage.Kind.ERROR, msg));
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.ABORT;
        if (exitCode == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(1);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resolveMissingDependencies(CompileContext context, Collection<JpsModule> modules) throws Exception {
        Collection<JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> libs = DependencyResolvingBuilder.getRepositoryLibraries(modules);
        if (!libs.isEmpty()) {
            ArtifactRepositoryManager repoManager = DependencyResolvingBuilder.getRepositoryManager(context);
            for (JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>> lib : libs) {
                JpsMavenRepositoryLibraryDescriptor descriptor = (JpsMavenRepositoryLibraryDescriptor)((JpsSimpleElement)lib.getProperties()).getData();
                ResourceGuard guard = ResourceGuard.get(context, descriptor);
                if (!guard.requestProcessing(context.getCancelStatus())) continue;
                try {
                    List required = lib.getFiles(JpsOrderRootType.COMPILED);
                    Iterator it = required.iterator();
                    while (it.hasNext()) {
                        if (!((File)it.next()).exists()) continue;
                        it.remove();
                    }
                    if (required.isEmpty()) continue;
                    context.processMessage(new ProgressMessage("Resolving '" + lib.getName() + "' library..."));
                    LOG.debug("Downloading missing files for " + lib.getName() + " library: " + required);
                    Collection resolved = repoManager.resolveDependency(descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion());
                    if (!resolved.isEmpty()) {
                        DependencyResolvingBuilder.syncPaths(required, resolved);
                        continue;
                    }
                    LOG.info("No artifacts were resolved for repository dependency " + descriptor.getMavenId());
                }
                catch (TransferCancelledException e) {
                    context.checkCanceled();
                }
                finally {
                    guard.finish();
                }
            }
        }
    }

    private static void syncPaths(Collection<File> required, @NotNull Collection<File> resolved) throws Exception {
        if (resolved == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(2);
        }
        THashSet libFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        libFiles.addAll(required);
        libFiles.removeAll(resolved);
        if (!libFiles.isEmpty()) {
            THashMap nameToArtifactMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            for (File f : resolved) {
                File prev = nameToArtifactMap.put(f.getName(), f);
                if (prev == null) continue;
                throw new Exception("Ambiguous artifacts with the same name: " + prev.getPath() + " and " + f.getPath());
            }
            for (File file : libFiles) {
                File resolvedArtifact = (File)nameToArtifactMap.get(file.getName());
                if (resolvedArtifact == null) continue;
                FileUtil.copy((File)resolvedArtifact, (File)file);
            }
        }
    }

    @NotNull
    private static Collection<JpsTypedLibrary<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>>> getRepositoryLibraries(Collection<JpsModule> modules) {
        SmartHashSet result = new SmartHashSet();
        for (JpsModule module : modules) {
            for (JpsDependencyElement dep : module.getDependenciesList().getDependencies()) {
                JpsLibrary _lib;
                JpsTypedLibrary lib;
                if (!(dep instanceof JpsLibraryDependency) || (lib = (_lib = ((JpsLibraryDependency)dep).getLibrary()) != null ? _lib.asTyped((JpsLibraryType)JpsRepositoryLibraryType.INSTANCE) : null) == null) continue;
                result.add(lib);
            }
        }
        SmartHashSet smartHashSet = result;
        if (smartHashSet == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(3);
        }
        return smartHashSet;
    }

    private static ArtifactRepositoryManager getRepositoryManager(final CompileContext context) {
        ArtifactRepositoryManager manager = (ArtifactRepositoryManager)MANAGER_KEY.get((UserDataHolder)context);
        if (manager == null) {
            SmartList repositories = new SmartList();
            for (JpsRemoteRepositoryDescription repo : JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(context.getProjectDescriptor().getProject()).getRepositories()) {
                repositories.add(ArtifactRepositoryManager.createRemoteRepository((String)repo.getId(), (String)repo.getUrl()));
            }
            manager = new ArtifactRepositoryManager(DependencyResolvingBuilder.getLocalRepoDir(context), (List)repositories, new ProgressConsumer(){

                public void consume(String message) {
                    context.processMessage(new ProgressMessage(message));
                }

                public boolean isCanceled() {
                    return context.getCancelStatus().isCanceled();
                }
            });
            MANAGER_KEY.set((UserDataHolder)context, (Object)manager);
        }
        return manager;
    }

    @NotNull
    private static File getLocalRepoDir(CompileContext context) {
        String localRepoPath;
        JpsPathVariablesConfiguration pvConfig = JpsModelSerializationDataService.getPathVariablesConfiguration((JpsGlobal)context.getProjectDescriptor().getModel().getGlobal());
        String string = localRepoPath = pvConfig != null ? pvConfig.getUserVariableValue(MAVEN_REPOSITORY_PATH_VAR) : null;
        if (localRepoPath != null) {
            File file = new File(localRepoPath);
            if (file == null) {
                DependencyResolvingBuilder.$$$reportNull$$$0(4);
            }
            return file;
        }
        String root = System.getProperty("user.home", null);
        File file = root != null ? new File(root, DEFAULT_MAVEN_REPOSITORY_PATH) : new File(DEFAULT_MAVEN_REPOSITORY_PATH);
        if (file == null) {
            DependencyResolvingBuilder.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reportError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryLibraries";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepoDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ResourceGuard {
        private static final Key<ConcurrentMap<JpsMavenRepositoryLibraryDescriptor, ResourceGuard>> CONTEXT_KEY = GlobalContextKey.create("_artifact_repository_resolved_libraries_");
        private static final byte INITIAL = 0;
        private static final byte PROGRESS = 1;
        private static final byte FINISHED = 2;
        private byte myState = 0;

        private ResourceGuard() {
        }

        synchronized boolean requestProcessing(CanceledStatus cancelStatus) {
            if (this.myState == 0) {
                this.myState = 1;
                return true;
            }
            while (this.myState == 1 && !cancelStatus.isCanceled()) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }

        synchronized void finish() {
            if (this.myState != 2) {
                this.myState = (byte)2;
                this.notifyAll();
            }
        }

        static void init(CompileContext context) {
            context.putUserData(CONTEXT_KEY, ContainerUtil.newConcurrentMap());
        }

        @NotNull
        static ResourceGuard get(CompileContext context, JpsMavenRepositoryLibraryDescriptor descriptor) {
            ConcurrentMap map = (ConcurrentMap)context.getUserData(CONTEXT_KEY);
            assert (map != null);
            ResourceGuard g = new ResourceGuard();
            ResourceGuard existing = map.putIfAbsent(descriptor, g);
            ResourceGuard resourceGuard = existing != null ? existing : g;
            if (resourceGuard == null) {
                ResourceGuard.$$$reportNull$$$0(0);
            }
            return resourceGuard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/dependencies/DependencyResolvingBuilder$ResourceGuard", "get"));
        }
    }
}

